<?php

namespace apexl\Io\middleware;

use apexl\Io\services\HttpPaths;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Slim\Routing\RouteContext;

final readonly class AddRouteToHttpPaths implements MiddlewareInterface
{
    public function __construct(private HttpPaths $httpPaths) {}

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): Response
    {
        $routeContext = RouteContext::fromRequest($request);
        $route = $routeContext->getRoute();

        $this->httpPaths->route = $route;

        return $handler->handle($request);
    }
}
