<?php

declare(strict_types=1);

namespace apexl\Io\requestHelper;

use Psr\Http\Message\ServerRequestInterface;

abstract readonly class requestHelper
{
    protected ?object $body;
    protected array $query;

    public function __construct(protected ServerRequestInterface $request)
    {
        $body = $request->getParsedBody();

        $this->query = $request->getQueryParams();

        $this->body = $body ? (object) $body : null;
    }

    public static function factory(ServerRequestInterface $request): static
    {
        return container()->make(static::class, ['request' => $request]);
    }

    protected function bodyParam($name, $default = null)
    {
        return $this->body->{$name} ?? $default;
    }

    protected function query($name, $default = null)
    {
        return $this->query[$name] ?? $default;
    }


}
