<?php

namespace apexl\Io\modules\system\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\services\GlobalData;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class GetGlobalDataController extends Controller
{
    /**
     * We allow any module to set 'global' data with middleware so we can grab it here.
     * This should contain information such as branding, user details, global meta etc.
     * @method GET
     */
    public function __invoke(GlobalData $globalData, ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        return $this->json($response, $globalData->getData());
    }
}
