<?php

declare(strict_types=1);

namespace apexl\Io\factories;

use apexl\Io\exceptions\ValidationException;
use apexl\Io\requestHelper\requestHelper;
use DI\Container;
use Psr\Http\Message\ServerRequestInterface;

final readonly class RequestHelperFactory
{
    public function __construct(
        private Container $container,
    ) {}

    /**
     * @param class-string<RequestHelper> $helperClass
     * @throws ValidationException
     */
    public function make(string $helperClass, ServerRequestInterface $request): requestHelper
    {
        assert(
            is_a($helperClass, RequestHelper::class, true),
            sprintf('`%s` must be an instance of `%s`', $helperClass, RequestHelper::class)
        );

        return $this->container->make($helperClass, ['request' => $request]);
    }
}