<?php

/**
 * @noinspection PhpUnhandledExceptionInspection
 *
 * Exceptions thrown by Controller will be handled by global Whoops handler(s)
 */

namespace apexl\Io\includes;

use apexl\Io\exceptions\JsonRecursionException;
use apexl\Io\services\Output;
use JsonException;
use Psr\Http\Message\ResponseInterface;

abstract readonly class Controller
{
    public function __construct(protected Output $output) {}

    protected function throw404(ResponseInterface $response): ResponseInterface
    {
        return $this->json($response, status: 404);
    }

    protected function json(ResponseInterface $response, array $data = [], int $status = 200): ResponseInterface
    {
        $response = $response
            ->withHeader('Content-Type', 'application/json');

        $data = array_merge($data, $this->output->getOutput());

        try {
            $response->getBody()->write(json_encode($data, JSON_THROW_ON_ERROR));
        } catch (JsonException $e) {
            if ($e->getCode() === JSON_ERROR_RECURSION) {
                throw new JsonRecursionException($data);
            }

            throw $e;
        }

        return $response
            ->withStatus($status);
    }

}
