<?php

namespace apexl\Io\modules\authentication;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\Module;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\authentication\controllers\authenticationController;
use apexl\Io\modules\system\interfaces\ProvidesRoutesInterface;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class authenticationModule extends Module implements ProvidesRoutesInterface
{
    public function initialise(): void
    {
        parent::initialise();
        $this->setBaseRoute('');
    }

    public function routes(RouteManager $routeManager): void
    {
        //we have no db data so lets assume we're installing.
        $this->addRoute(
            $routeManager,
            HttpMethod::GET,
            'core.authenticated',
            '/authenticated',
            authenticationController::class . ':authenticated'
        );
    }
}
