<?php
declare(strict_types=1);

use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class ChangeModuleNamespaceToModule extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('modules')
            ->removeColumn('name')
            ->renameColumn('namespace', 'module')
            ->removeIndex('module')
            ->addIndex('module', [
                Index::UNIQUE => true,
            ])
            ->update();
    }
}
