<?php

namespace apexl\Io\modules\installDisplay;

use apexl\Io\includes\Module;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\system\interfaces\ProvidesRoutesInterface;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\installDisplay
 */
class installDisplayModule extends Module implements ProvidesRoutesInterface
{
    public function initialise(): void
    {
        parent::initialise();
        $this->setBaseRoute('/');
    }


    public function routes(RouteManager $routeManager): void
    {
        //These are installing routes, so only include them if we need to install.
        if ($this->installChecker->isInstalling) {
            //@route /install
            $this->addRoute(
                $routeManager,
                'GET',
                'install.start',
                'install',
                installDisplayController::class . ':start'
            );
        }
    }
}
