<?php

namespace apexl\Io\includes;

use apexl\Io\services\VariableManager;
use Deprecated;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;
use function apexl\Io\container;

class System
{
    #[Deprecated(message: 'Use `VariableManager::HOOK__GET_VARIABLE` instead')]
    public final const string HOOK__GET_VARIABLE = VariableManager::HOOK__GET_VARIABLE;
    private static ?System $instance;

    #[Deprecated (message: '`System` has been deprecated')]
    public static function getInstance(): System
    {
        if (!isset(self::$instance)) {
            self::$instance = new System();
        }

        return self::$instance;
    }

    public static function reset(): void
    {
        self::$instance = null;
    }

    #[Deprecated(message: 'Use DI factory instead')]
    public static function makeRegisteredService(string $service, array $params = []): mixed
    {
        return container()->make($service, $params);
    }

    #[Deprecated(message: 'Use VariableManager::set() instead')]
    public static function setVariable(string $name, mixed $data, int $site = 1): void
    {
        System::getRegisteredService(VariableManager::class)->set($name, $data, $site);
    }

    #[Deprecated(message: 'Use DI instead')]
    public static function getRegisteredService($service): mixed
    {
        try {
            return container()->get($service);
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface $e) {
            self::handleServiceException($e);

            return null;
        }
    }

    private static function handleServiceException(ContainerExceptionInterface|NotFoundExceptionInterface $e): void
    {
        user_error($e->getMessage(), E_USER_ERROR);
    }

    #[Deprecated(message: 'Use VariableManager::has() instead')]
    public static function hasVariable(string $name, int $site = 1): bool
    {
        return System::getRegisteredService(VariableManager::class)->has($name, $site);
    }

    #[Deprecated(message: 'Use VariableManager::get() instead')]
    public static function getVariable(string $name, int $site = 1): mixed
    {
        return System::getRegisteredService(VariableManager::class)->get($name, $site);
    }

    #[Deprecated(message: 'Use VariableManager::all() instead')]
    public static function getVariables(int $site = 1): array
    {
        return System::getRegisteredService(VariableManager::class)->all($site);
    }

    #[Deprecated(message: 'Use VariableManager::delete() instead')]
    public static function deleteVariable(string $name, int $site = 1): void
    {
        System::getRegisteredService(VariableManager::class)->delete($name, $site);
    }
}
