<?php

namespace apexl\Io\modules\install\controllers;

use apexl\Io\includes\System;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final readonly class listController
{
    public function __invoke(Request $request, Response $response): Response
    {
        return $this->json($response, $this->modules());
    }

    private function modules(): array
    {
        return array_map(fn(object $module): string => $module->name, System::$module->getActiveModules());
    }
}
