<?php

declare(strict_types=1);

namespace apexl\Io\services;

use apexl\Io\modules\user\traits\Appends;

final readonly class FilePaths
{
    use Appends;

    private string $configDir;
    private string $webRoot;


    public function __construct(
        private string $basePath,
        $configDir = './config',
        $webRoot = './web'
    ) {
        $this->configDir = realpath(sprintf('%s/%s', $this->basePath, $configDir));
        $this->webRoot = realpath(sprintf('%s/%s', $this->basePath, $webRoot));
    }

    public function basePath(string $append = ''): string
    {
        return $this->append($this->basePath, $append);
    }

    public function configDir(string $append = ''): string
    {
        return $this->append($this->configDir, $append);
    }

    public function webRoot(string $append = ''): string
    {
        return $this->append($this->webRoot, $append);
    }

}