# README #

This README would normally document whatever steps are necessary to get your application up and running.

### What is this repository for? ###

IO is a restful Framework and CMS for everything from SaaS projects to Websites.

### How do I get set up? ###

Run composer install in the root. This will install and configure the project, you can then add new functionality with
composer require.

## System Architecture

### Requests

#### Injection

Requests are injected into controllers. If no specific request is typehinted (or `Psr\Http\Message\ServerRequestInterface;
` is typehinted), an instance of `Slim\Psr7\Request` will be provided.

If a specific request, which extends `apexl\Io\Request\IoRequest` is typehinted, this will be injected instead.
This means that we can have requests with helper functions to fetch request data:

```
    final readonly class MyController extends Controller
    {
        public function __invoke(ServerRequestInterface $request, ResponseInterface $response)
        {
            // No specific request was typehinted, so an instance of Slim\Psr7\Request is provided
            $foo = $request->getQueryParams()['foo'] ?? 'default';
            
            $bar = $request->getParsedBody()['bar'] ?? 'default';
        } 
    }
```

```
    final class MyRequest extends IoRequest
    {
        public method foo(): string
        {
            return $this->query('foo', 'default');
        }

        public method bar(): string
        {
            return $this->bodyParam('bar', 'default');
        }
    }
    
    final readonly class MyController extends Controller
    {
        public function __invoke(MyRequest $request, ResponseInterface $response)
        {
            // An instance of MyRequest is provided
            $foo = $request->foo();
            
            $bar = $request->bar();
        } 
    }

```

#### Validation

@Todo...

## Contact ##

Toby New - toby.new@source-control.co.uk