<?php

declare(strict_types=1);

namespace apexl\Io\Request;

use Psr\Http\Message\StreamInterface;
use Psr\Http\Message\UriInterface;
use Slim\Psr7\Interfaces\HeadersInterface;
use Slim\Psr7\Request;

abstract class IoRequest extends Request
{
    public function __construct(
        $method,
        UriInterface $uri,
        HeadersInterface $headers,
        array $cookies,
        array $serverParams,
        StreamInterface $body,
        array $uploadedFiles = [],
        array $attributes = []
    ) {
        parent::__construct(
            $method,
            $uri,
            $headers,
            $cookies,
            $serverParams,
            $body,
            $uploadedFiles
        );

        $this->attributes = $attributes;
    }

    protected function bodyParam($name, $default = null)
    {
        return $this->getParsedBody()[$name] ?? $default;
    }

    protected function query($name, $default = null)
    {
        return $this->getQueryParams()[$name] ?? $default;
    }
}
