<?php

declare(strict_types=1);

namespace apexl\Io\collections;

use app\vendor\apexl\io\src\Io\modules\system\commands\DaedalusCommand;
use Arrayy\Collection\AbstractCollection;
use function apexl\Io\assertInstanceOf;

class DaedalusCommandCollection extends AbstractCollection
{
    /**
     * @param class-string<DaedalusCommand> $value
     * @param $key
     * @return DaedalusCommandCollection
     */
    public function add($value, $key = null): DaedalusCommandCollection
    {
        assertInstanceOf($value, DaedalusCommand::class);

        return parent::add($value, $key);
    }

    public function getType(): string
    {
        return 'string';
    }
}
