<?php

namespace apexl\Io\services;

use apexl\Io\factories\PHPMailerFactory;
use PHPMailer\PHPMailer\PHPMailer;

/**
 * @mixin PHPMailer
 */
final readonly class Mailer
{
    private PHPMailer $mail;

    public function __construct(PHPMailerFactory $mailFactory)
    {
        $this->mail = $mailFactory->make();
    }

    public function __get($name)
    {
        return $this->mail->$name;
    }

    public function __set($name, $value)
    {
        $this->mail->$name = $value;
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     */
    public function __call($name, $arguments)
    {
        try {
            //pass-through calls to $this->mail
            if (!empty($arguments)) {
                return $this->mail->$name(...$arguments);
            } else {
                return $this->mail->$name();
            }
        } catch (\Exception $e) {
            error_log("[IO Exception :: Mailer] -" . $e->getCode() . " | " . $e->getMessage());

            return $e;
        }
    }
}
