<?php

declare(strict_types=1);

namespace apexl\Io\factories;

use apexl\Io\Client;
use apexl\Io\includes\HookManager;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\system\services\ModuleManager;
use apexl\Io\services\InstallChecker;
use apexl\Io\services\Output;
use Slim\App;

final readonly class ClientFactory
{
    public function __construct(
        private App $app,
        private ModuleManager $modules,
        private InstallChecker $installChecker,
        private Output $output,
        private RouteManager $routeManager,
        private HookManager $hookManager,
    ) {}

    public function make(): Client
    {
        return new Client(
            application: $this->app,
            moduleManager: $this->modules,
            installChecker: $this->installChecker,
            outputManager: $this->output,
            routeManager: $this->routeManager,
            hookManager: $this->hookManager,
        );
    }
}