<?php

declare(strict_types=1);

use apexl\Config\Configuration;
use apexl\Io\includes\Utils;
use apexl\Io\services\FilePaths;

return [
    Configuration::class => function (FilePaths $filePaths): Configuration {
        $config = new Configuration();

        $files = Utils::getFilesInDirectory($filePaths->configDir(), ['php'], ['.local.php', '.example.php']);

        ksort($files, SORT_NATURAL); //ensure we load based on file order, not alpha (in case this matters).
        foreach ($files as $file) {
            $config->load($file);
        }

        return $config;
    },
];
