<?php

declare(strict_types=1);

namespace apexl\Io\Request;

use apexl\Io\enums\HttpMethod;
use Psr\Http\Message\StreamInterface;
use Psr\Http\Message\UriInterface;
use Slim\Psr7\Interfaces\HeadersInterface;
use Slim\Psr7\Request;

abstract class IoRequest extends Request
{
    public function __construct(
        $method,
        UriInterface $uri,
        HeadersInterface $headers,
        array $cookies,
        array $serverParams,
        StreamInterface $body,
        array $uploadedFiles,
    ) {
        parent::__construct(
            $method,
            $uri,
            $headers,
            $cookies,
            $serverParams,
            $body,
            $uploadedFiles
        );
    }

    public function isMethod(HTTPMethod $method, HttpMethod ...$methods): bool
    {
        return array_any([$method, ...$methods], fn(HttpMethod $method): bool => $this->getMethod() === $method->name);
    }

    protected function bodyParam($name, $default = null)
    {
        return $this->getParsedBody()[$name] ?? $default;
    }

    protected function query($name, $default = null)
    {
        return $this->getQueryParams()[$name] ?? $default;
    }
}
