<?php

namespace apexl\Io\recommendedIncludes;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\Module;
use apexl\Io\includes\RouteManager;

/**
 * Class apiModule
 * Sets a number of expected system defaults - can be overridden with config.
 * @package apexl\Io\recommendedIncludes
 */
class apiModule extends Module
{
    public function initialise(): void
    {
        parent::initialise();
        $this->setBaseRoute(
            sprintf('/api/v%d/%s', $this->apiVersion(), strtolower($this->getName()))
        );
    }

    public function addActionRoute(
        RouteManager $routeManager,
        HttpMethod $verb,
        string $name,
        string $pattern,
        $callable
    ): apiModule {
        $this->addRoute(
            $routeManager,
            $verb,
            $name,
            '/action/' . ltrim($pattern, '/'),
            $callable
        );

        return $this;
    }

    public function addDataRoute(
        RouteManager $routeManager,
        HttpMethod $verb,
        string $name,
        string $pattern,
        $callable
    ): apiModule {
        $this->addRoute(
            $routeManager,
            $verb,
            $name,
            '/data/' . ltrim($pattern, '/'),
            $callable
        );

        return $this;
    }
}
