<?php

declare(strict_types=1);

namespace apexl\Io\modules\system\collections;

use Arrayy\Arrayy;
use Psr\Http\Server\MiddlewareInterface;
use function apexl\Io\assertInstanceOf;

final class MiddlewareCollection extends Arrayy
{
    /**
     * @param MiddlewareInterface|class-string<MiddlewareInterface> $value
     */
    public function add($value, $key = null): MiddlewareCollection
    {
        assertInstanceOf($value, MiddlewareInterface::class);

        return parent::add($value, $key);
    }

    /**
     * @param MiddlewareInterface|class-string<MiddlewareInterface> $value
     */
    public function set($key, $value): MiddlewareCollection
    {
        assertInstanceOf($value, MiddlewareInterface::class);

        return parent::set($key, $value);
    }
}