<?php

declare(strict_types=1);

namespace apexl\Io\modules\system\collections;

use apexl\Io\modules\system\services\MiddlewareCollector;
use Arrayy\Arrayy;
use Arrayy\Collection\AbstractCollection;
use Arrayy\Type\TypeInterface;

/**
 * @extends Arrayy<int,MiddlewareCollection>
 */
final class MiddlewareCollectionCollection extends AbstractCollection implements TypeInterface
{
    public function getType(): string
    {
        return MiddlewareCollection::class;
    }

    public function add($value, $key = null, $weight = MiddlewareCollector::WEIGHT__MIDDLE): MiddlewareCollectionCollection
    {
        $group = parent::get($weight) ?? new MiddlewareCollection();

        $group->add($value, $key);

        return parent::set($weight, $group);
    }
}