<?php

namespace apexl\Io\includes;

class Routes {
    protected $Io;
    protected $permissions;
    protected $menu;
    protected $lastAdded;

    public function __construct(){
        $this->Io = System::$app;
        //check if these modules exist.
        if(class_exists('\apexl\Io\modules\user\userModule')){
            $this->permissions = \apexl\Io\modules\user\services\Permissions::getInstance();
        }
        if(class_exists('\apexl\Io\modules\menu\menuModule')){
            $this->menu = \apexl\Io\modules\menu\services\Menu::getInstance();
        }
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function get(string $pattern, $callable, $permission = 'canDoNothing', $registerProtectedRoute = TRUE){
        $this->Io->get($pattern, $callable)->setArgument('permission', $permission);
        //now we set the menu and permissions data, if they exist.
        $this->registerPermission($pattern, $permission, $registerProtectedRoute);
        return $this;
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function post(string $pattern, $callable, $permission = 'canDoNothing', $registerProtectedRoute = FALSE){
        $this->Io->post($pattern, $callable)->setArgument('permission', $permission);
        $this->registerPermission($pattern, $permission, $registerProtectedRoute);
        return $this;
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function put(string $pattern, $callable, $permission = 'canDoNothing', $registerProtectedRoute = FALSE){
        $this->Io->put($pattern, $callable)->setArgument('permission', $permission);
        $this->registerPermission($pattern, $permission, $registerProtectedRoute);
        return $this;
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function delete(string $pattern, $callable, $permission = ['canDoNothing' => 'No Access'], $registerProtectedRoute = FALSE){
        $this->Io->delete($pattern, $callable)->setArgument('permission', $permission);
        $this->registerPermission($pattern, $permission, $registerProtectedRoute);
        return $this;
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function any(string $pattern, $callable, $permission = ['canDoNothing' => 'No Access'], $registerProtectedRoute = TRUE){
        $this->Io->any($pattern, $callable)->setArgument('permission', $permission);
        $this->registerPermission($pattern, $permission, $registerProtectedRoute);
        return $this;
    }

    //not sure this will work...
    public function group($pattern, $callable){
        $this->Io->group($pattern, $callable);
        return $this;
    }

    protected function registerPermission($pattern, $permission, $registerProtectedRoute = FALSE){
        if($this->permissions){
            //used by the menu module
            if($registerProtectedRoute){
                $this->permissions->registerProtectedRoute($pattern, $permission);
            }
        }
        $this->lastAdded = (object)["route" => $pattern, "permission" => $permission];

        return $this;
    }

    public function addToMenu($title, $icon, $parent = FALSE){
        $item = [
            "title" => $title,
            "href" => $this->lastAdded->route,
            "permission" => $this->lastAdded->permission,
            "icon" => $icon
        ];
        if($parent){
            $this->menu->registerMenuChildItem($parent, $item);
        } else {
            $this->menu->registerMenuItem($this->lastAdded->route, $item);
        }
    }
}