<?php

namespace apexl\Io\modules\install;

use apexl\Io\includes\Module;
use apexl\Io\includes\System;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class installModule extends Module {

    public function __construct()
    {
        parent::__construct();
    }

    public function routes(){
        //we have no db data so lets assume we're installing.
        $installPath = System::getInstallPath();

        $this->route->get('/'.$installPath.'/list', installController::class.':list');
        //default install path - allows posting of data to the endpoint.
        //$this->route->post('/'.$installPath, installController::class.':install');
        $this->route->post('/'.$installPath.'/automatic', installController::class.':automatic');
    }

    /**
     * Provide the install modules Schema.
     * @return mixed|void
     */
    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }
}