<?php

namespace apexl\Io\modules\installDisplay;
use apexl\Config\Singleton;
use apexl\Io\includes\System;
use apexl\Io\services\Output;
use apexl\Io\services\pathUtility;

use apexl\Vault\Vault;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class installDisplayController{

    /** @var pathUtility  */
    protected $path;
    /** @var Vault  */
    protected $database;
    /** @var Singleton  */
    protected $config;

    public function __construct(pathUtility $path, Vault $database, Singleton $config)
    {
        $this->path = $path;
        $this->database = $database;
        $this->config = $config;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @return Response
     * @method GET
     */
    public function start(Request $request, Response $response): Response
    {
        //We're installing
        Output::addResponse($request, ['thing' => 'stuff']);
        return System::asJson($response, []);
    }

}