<?php

namespace apexl\Io\utilityIncludes;

class route {
    protected $name;
    protected $verb;
    protected $callable;
    protected $pattern;
    protected $args = [];

    public function __construct($name = NULL, $pattern = NULL, $callable = NULL, $verb = 'get',  $args = [])
    {
        $this->name($name);
        $this->pattern($pattern);
        $this->callable($callable);
        $this->verb($verb);
        if(!empty($args)) {
            foreach ($args as $name => $arg)
            $this->arg($name, $arg);
        }
    }

    /**
     * set route name
     * @param $name
     * @return $this
     */
    public function name($name){
        $this->name = $name;
        return $this;
    }

    /**
     * set route pattern
     * @param $pattern
     * @return $this
     */
    public function pattern($pattern){
        $this->pattern = $pattern;
        return $this;
    }

    /**
     * set route callable
     * @param $callable
     * @return $this
     */
    public function callable($callable){
        $this->callable = $callable;
        return $this;
    }

    /**
     * set route verb
     * @param $verb
     * @return $this
     */
    public function verb($verb){
        $this->verb = strtolower($verb);
        return $this;
    }

    /**
     * add a route arg
     * @param $name
     * @param $value
     * @return route
     */
    public function arg($name,  $value){
        $this->args[$name] = $value;
        return $this;
    }

    public function getArgs($arg = NULL){
        return $this->args[$arg] ?? $this->args;
    }

    public function getName(){return $this->name;}
    public function getPattern(){return $this->pattern;}
    public function getCallable(){return $this->callable;}
    public function getVerb(){return $this->verb;}
}