<?php

namespace apexl\Io\includes;

class Routes {
    protected $Io;
    protected $menu;
    protected $lastAdded;

    public function __construct(){
        $this->Io = System::$app;
        $this->menu = NULL;
        //check if these modules exist.
        if(class_exists('\apexl\Io\modules\menu\menuModule')){
            $this->menu = \apexl\Io\modules\menu\services\Menu::getInstance();
        }
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function get(string $pattern, $callable, $permission = 'canDoNothing'){
        $this->Io->get($pattern, $callable)->setArgument('permission', $permission);
        //now we set the menu and permissions data, if they exist.
        $this->registerPermission($pattern, $permission);
        return $this;
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function post(string $pattern, $callable, $permission = 'canDoNothing'){
        $this->Io->post($pattern, $callable)->setArgument('permission', $permission);
        $this->registerPermission($pattern, $permission);
        return $this;
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function put(string $pattern, $callable, $permission = 'canDoNothing'){
        $this->Io->put($pattern, $callable)->setArgument('permission', $permission);
        $this->registerPermission($pattern, $permission);
        return $this;
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function delete(string $pattern, $callable, $permission = ['canDoNothing' => 'No Access']){
        $this->Io->delete($pattern, $callable)->setArgument('permission', $permission);
        $this->registerPermission($pattern, $permission);
        return $this;
    }

    /**
     * @param string $pattern
     * @param $callable
     * @param string|array $permission
     * @return $this
     */
    public function any(string $pattern, $callable, $permission = ['canDoNothing' => 'No Access']){
        $this->Io->any($pattern, $callable)->setArgument('permission', $permission);
        $this->registerPermission($pattern, $permission);
        return $this;
    }

    //not sure this will work...
    public function group($pattern, $callable){
        $this->Io->group($pattern, $callable);
        return $this;
    }

    protected function registerPermission($pattern, $permission){
        $this->lastAdded = (object)["route" => $pattern, "permission" => $permission];
        return $this;
    }

    public function addToMenu($title, $icon, $parent = FALSE, $menuName = 'navigation'){
        if($this->menu) {
            $item = (object)[
                "title" => $title,
                "href" => $this->lastAdded->route,
                "permission" => $this->lastAdded->permission,
                "icon" => $icon
            ];
            $this->menu->addToMenu($item, $parent, $menuName);
        }
    }
}