<?php
namespace apexl\Io\services;

use apexl\ClassEngine\EngineSingleton;

class pathUtility extends EngineSingleton {

    protected $currentPathData;

    protected function __construct()
    {
        parent::__construct();
        $this->setCurrentPath();
    }

    /**
     * Function to get either the full path, or a single element of it.
     * @param bool $position
     * @param bool $withQuery
     * @return string
     */
    public function getPath($position = FALSE, $withQuery = FALSE): string
    {
        if($position !== FALSE){
            return $this->currentPathData['path_items'][$position] ?? '';
        } elseif ($withQuery) {
            return $this->currentPathData['full_path'];
        } else {
            return $this->currentPathData['full_path_no_query'];
        }
    }

    /**
     * Function to set the current path based on the request.
     */
    protected function setCurrentPath(){
        //account for windows weirdness
        $requestUri = $_SERVER['REQUEST_URI'];
        //if the first 2 chars are slashes, take one off.
        if(substr($requestUri, 0, 2) == "//") {
            $requestUri = substr($requestUri, 2);
        }
        $pathInfo = pathinfo($requestUri);
        $fullPath = $pathInfo['dirname'] != DIRECTORY_SEPARATOR ? ltrim($pathInfo['dirname'].DIRECTORY_SEPARATOR.$pathInfo['basename'], DIRECTORY_SEPARATOR) : ltrim($pathInfo['dirname'].$pathInfo['basename'], DIRECTORY_SEPARATOR);
        $pathItems = $pathInfo['dirname'] != DIRECTORY_SEPARATOR ? explode(DIRECTORY_SEPARATOR, strtok($fullPath, '?')) : [strtok($fullPath, '?')];
        $this->currentPathData = [
            'full_path_no_query' => $fullPath != DIRECTORY_SEPARATOR ? implode(DIRECTORY_SEPARATOR, $pathItems) : $fullPath,
            'full_path' => $fullPath,
            'path_items' => $pathItems,
            'no_path_items' => count($pathItems),
            'endpoint' => $pathInfo['basename']
        ];
    }
}