<?php

namespace apexl\Io\recommendedIncludes;

use apexl\Io\includes\Module;

/**
 * Class displayModule
 * Sets a number of expected system defaults - can be overridden with config.
 * @package apexl\Io\recommendedIncludes
 */
class displayModule extends Module {
    public function __construct()
    {
        parent::__construct();
        $this->setBaseRoute('/display/v'.$this->apiVersion().'/'.strtolower($this->getName()));
    }

    public function addDisplayRoute($verb, $name, string $pattern, $callable): displayModule
    {
        $this->addRoute($verb, $name, '/display/'.ltrim($pattern, '/'), $callable);
        return $this;
    }
}