<?php

declare(strict_types=1);

namespace apexl\Io\requestHelper;

use apexl\Io\includes\System;
use Psr\Http\Message\ServerRequestInterface;

abstract readonly class requestHelper
{
    protected ?object $body;
    protected array $query;

    public function __construct(protected ServerRequestInterface $request, protected array $args = [])
    {
        $body = $request->getParsedBody();

        $this->query = $request->getQueryParams();

        $this->body = $body ? (object) $body : null;
    }

    public static function factory(ServerRequestInterface $request, array $args = []): RequestHelper
    {
        return System::makeRegisteredService(static::class, ['request' => $request, 'args' => $args]);
    }

    protected function bodyParam($name, $default = null)
    {
        return $this->body->{$name} ?? $default;
    }

    protected function arg($name, $default = null)
    {
        return $this->args[$name] ?? $default;
    }

    protected function query($name, $default = null)
    {
        return $this->query[$name] ?? $default;
    }


}
