<?php

namespace apexl\Io\modules\coachingForms\callbacks;

use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\services\pathUtility;

class accessControl {

    /**
     * @impliments entityAccess hook
     * @param $query
     * @param $table
     * @return mixed
     */
    public static function entityLoadMultipleQuery($query, $table){
        //we need to alter most base entity queries to include an access check.
        //We'll add in our own hook here to allow other processes to alter the checks for specific entities

        //Access control is administered by: Global permission > Company ownership > Company permission > Own Ownership.
        /** @var  userEntity */
        $query = clone $query; // prevent further modifications to the query.
        switch($table) {
            case 'complete_form':
                $path = pathUtility::getInstance();
                $url = $path->getPath();
                $currentUser = currentUser::getCurrentUser();

                if($table == 'complete_form'){
                    $query->join('users', 'complete_form.staff_id', 'users.id');
                }

                //query by route, default to perms.
                switch ($url){
                    case 'reports/company':
                    case 'reports/company/components':
                        if ($currentUser->isAllowed('ViewAllCoachingStaff')) {
                            $query->join('coaching_teams cts', 'cts.user_id', ($table == 'complete_form' ? 'staff_id' : 'users.id'));
                            $query->leftJoin('coaching_teams ctt', 'ctt.user_id', 'cts.team_leader_id');
                            return $query;
                        }
                        break;
                    case 'reports/team':
                    case 'reports/team/components':
                        if($currentUser->isAllowed('ViewAllCoachingStaff') || $currentUser->isAllowed('ViewSalesTeamCoachingStaff')){
                            return self::smQuery($currentUser, $query, $table);
                        }
                        if($currentUser->isAllowed('ViewTeamCoachingStaff')){
                            return self::tlQuery($currentUser, $query, $table);
                        }
                        break;
                    case 'reports/individual':
                    case 'reports/individual/components':
                        if ($currentUser->isAllowed('ViewOwnReports')) {
                            return self::staffQuery($currentUser, $query, $table);
                        }
                        break;
                    default:
                        if ($currentUser->isAllowed('ViewAllCoachingStaff')) {
                            return $query;
                        }
                        if($currentUser->isAllowed('ViewSalesTeamCoachingStaff')){
                            return self::smQuery($currentUser, $query, $table);
                        }
                        if($currentUser->isAllowed('ViewTeamCoachingStaff')){
                            return self::tlQuery($currentUser, $query, $table);
                        }
                        return self::staffQuery($currentUser, $query, $table);
                        break;
                }
                break;
            case 'users':
                $currentUser = currentUser::getCurrentUser();
                if ($currentUser->isAllowed('ViewAllCoachingStaff')) {
                    return $query;
                }
                if($currentUser->isAllowed('ViewSalesTeamCoachingStaff')){
                    return self::smQuery($currentUser, $query, $table);
                }
                if($currentUser->isAllowed('ViewTeamCoachingStaff')){
                    return self::tlQuery($currentUser, $query, $table);
                }
                if ($currentUser->isAllowed('ViewOwnReports')) {
                    return self::staffQuery($currentUser, $query, $table);
                }
                //default to staff only
                return self::staffQuery($currentUser, $query, $table);
                break;
        }
        return $query;
    }

    //SELECT complete_form.*
    //FROM complete_form
    //JOIN users ON complete_form.staff_id = users.id
    //JOIN coaching_teams cts ON cts.user_id = staff_id
    //LEFT JOIN coaching_teams ctt ON ctt.team_leader_id = cts.user_id
    //WHERE ( ctt.team_leader_id = 13 OR ctt.user_id = 13 OR ctt.team_leader_id IS NULL)
    //AND complete_form.team_leader_id = 13
    //ORDER BY  id DESC LIMIT 0,25
    protected static function smQuery($currentUser, $query, $table){
        $query->join('coaching_teams cts', 'cts.user_id', ($table == 'complete_form' ? 'staff_id' : 'users.id'));
        $query->leftJoin('coaching_teams ctt', 'ctt.user_id', 'cts.team_leader_id');
        $query->where('( ctt.team_leader_id', $currentUser->id);
        $query->where('ctt.team_leader_id', null, 'IS NULL', 'OR');
        $query->where('ctt.user_id', $currentUser->id, '=', 'OR', ')');
        return $query;
    }

    protected static function tlQuery($currentUser, $query, $table){
        $query->join('coaching_teams', 'user_id', ($table == 'complete_form' ? 'staff_id' : 'users.id'));
        $query->where('( coaching_teams.team_leader_id', $currentUser->id);
        $query->where('coaching_teams.user_id', $currentUser->id, '=', 'OR', ')');
        return $query;
    }

    protected static function staffQuery($currentUser, $query, $table){
        $query->where(($table == 'complete_form' ? 'staff_id' : 'users.id'), $currentUser->id);
        return $query;
    }

    public static function entityLoadQuery($query, $table){
        switch($table) {
            case 'users':
                $query->leftJoin('coaching_teams', 'user_id', 'users.id');
                break;
        }
        return $query;
    }

    public static function entityAccess($entity, $table){
        //if the entity failed to at all, just return it.
        if(!empty($entity)) {
            switch ($table) {
                case 'users':
                    //first, allow us to load ourselves, or allow managers to load the record.
                    $currentUser = currentUser::getCurrentUser();
                    if($currentUser->id == $entity['id'] || $currentUser->isAllowed('ViewAllCoachingStaff')){
                        return $entity;
                    }
                    //not ourselves, or a sales manager? Check we're this users team leader.
                    if (isset($entity['team_leader_id']) && !empty($entity['team_leader_id'])) {
                        //no match? empty the entity.
                        if($entity['team_leader_id'] != $currentUser->id){
                            $entity = [];
                        }
                    } else {
                        //No team leader record? empty the entity
                        $entity = [];
                    }
                    break;
            }
        }
        return $entity;
    }

    public static function entityLoadFields($fields, $table)
    {
        switch ($table) {
            case 'users':
                $currentUser = currentUser::getCurrentUser();
                if ($currentUser->isAllowed('ViewAllCoachingStaff')) {
                    $fields['coaching_teams'] = ['id as coaching_id', 'team_leader_id', 'user_id'];
                    return $fields;
                }
                if($currentUser->isAllowed('ViewSalesTeamCoachingStaff')){
                    $fields['coaching_teams'] = ['id as coaching_id', 'cts.team_leader_id as team_leader_id', 'user_id'];
                    return $fields;
                }
                if($currentUser->isAllowed('ViewTeamCoachingStaff')){
                    $fields['coaching_teams'] = ['id as coaching_id', 'team_leader_id', 'user_id'];
                    return $fields;
                }
                $fields['coaching_teams'] = ['id as coaching_id', 'team_leader_id', 'user_id'];
                return $fields;
                break;
        }

        return $fields;
    }

    public static function entityLoadMultipleFields($fields, $table)
    {
        switch ($table) {
            case 'users':
                $currentUser = currentUser::getCurrentUser();
                if ($currentUser->isAllowed('ViewAllCoachingStaff')) {
                    //nothing to do here, we can access everything.
                    return $fields;
                } else if($currentUser->isAllowed('ViewSalesTeamCoachingStaff')) {
                    $fields['coaching_teams'] = ['id as coaching_id', 'cts.team_leader_id as team_leader_id', 'user_id'];
                } else if ($currentUser->isAllowed('ViewTeamCoachingStaff')) {
                    $fields['coaching_teams'] = ['id as coaching_id', 'team_leader_id', 'user_id'];
                    return $fields;
                }
                break;
        }

        return $fields;
    }
}