<?php

namespace apexl\Io\modules\coachingForms\callbacks;

use apexl\Io\modules\coachingForms\entities\teamEntity;
use apexl\Io\modules\user\entities\roleEntity;

class userPostSave {

    /**
     * @impliments userPostSave hook
     * @param $query
     * @param $table
     * @return mixed
     */
    public static function alter($user, $request){
        $body = $request->getParsedBody();
        $team = new teamEntity();
        $team->loadByMember($user->id);

        //did we successfully load a team?
        if(!isset($team->id)){
            $team->user_id = $user->id;
        }

        //We need to check the selected team (if any) and create or update the record accordingly.
        if($teamId = $body->team_leader ?? FALSE){
            $team->team_leader_id = $body->team_leader;
            $team->store();
            //we also need to set the staff member role if we're in here.
            $roles = new roleEntity();
            $roles->loadByName("Staff Member");
            if($id = $roles->id ?? FALSE) {
                //only add the role if its not there already.
                if(!in_array($id, ($user->roles ?? []))) {
                    $user->addRole($id);
                    $user->store();
                }
            }
        } else {
            //no id? If we loaded a team but did not pass an ID, assume we need to delete this record.
            if(isset($team->id)){
                $team->delete();
            }
        }
        return $user;
    }
}