<?php

namespace apexl\Io\modules\coachingForms;

use apexl\Io\includes\Hook;
use apexl\Io\includes\Module;
use apexl\Io\includes\System;
use apexl\Io\modules\coachingForms\callbacks\accessControl;
use apexl\Io\modules\coachingForms\callbacks\userPostSave;
use apexl\Io\modules\coachingForms\controllers\coachingFormsController;
use apexl\Io\modules\coachingForms\controllers\manageCoachingPackagesController;
use apexl\Io\modules\coachingForms\controllers\coachingRecordsController;
use apexl\Io\modules\coachingForms\controllers\manageCoachingFormsController;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\user\services\Permissions;
use apexl\Vault\Vault;

class coachingFormsModule extends Module {
    public function __construct()
    {
        parent::__construct();
        $this->registerHooks();
    }

    /**
     * Module Route Declarations
     */
    public function routes(){
        $routes = $this->route;
        //get a group of routes.
        $groups = '/api/data';

        //Coaching Forms
        $routes->post($groups.'/coaching-forms', manageCoachingFormsController::class.':storeForm', 'ManageCoachingForms');
        $routes->put($groups.'/coaching-forms/{id}', manageCoachingFormsController::class.':storeForm', 'ManageCoachingForms');
        $routes->delete($groups.'/coaching-forms/{id}/delete',manageCoachingFormsController::class.':deleteForm', 'ManageCoachingForms');
        $routes->get($groups.'/coaching-forms[/{id}]', manageCoachingFormsController::class.':getForms','ViewCoachingForms');

        //Packages
        $routes->post($groups.'/coaching-packages', manageCoachingPackagesController::class.':storePackage', 'CreateCoachingPackage');
        $routes->delete($groups.'/coaching-packages/{id}/delete',manageCoachingPackagesController::class.':deletePackage', 'DeleteCoachingPackage');
        $routes->put($groups.'/coaching-packages/{id}', manageCoachingPackagesController::class.':storePackage', 'CreateCoachingPackage');
        $routes->get($groups.'/coaching-packages[/{id}]', manageCoachingPackagesController::class.':getPackages','ViewCoachingPackage');

        //Coaching records
        $routes->get($groups.'/coaching-records', coachingRecordsController::class.':getRecords', 'IsLoggedIn');
        $routes->post($groups.'/coaching-records', coachingRecordsController::class.':storeNewCoachingRecord', 'CompleteCoachingForms');
        $routes->put($groups.'/coaching-records/{id}', coachingRecordsController::class.':storeNewCoachingRecord', 'CompleteCoachingForms');

    }

    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    public function registerPermissions(Permissions $permissions){
        //Form Permissions
        $permissions->registerPermission('ManageCoachingForms', 'Manage Coaching Forms', 'Coaching Forms');
        $permissions->registerPermission('CompleteCoachingForms', 'Complete Coaching Forms', 'Coaching Forms');
        $permissions->registerPermission('ViewCoachingForms', 'View Coaching Forms', 'Coaching Forms');

        //Package Permissions
        $permissions->registerPermission('ViewCoachingPackage', 'View Coaching Packages', 'Coaching Packages');
        $permissions->registerPermission('CreateCoachingPackage', 'Create Coaching Package', 'Coaching Packages');
        $permissions->registerPermission('DeleteCoachingPackage', 'Delete Coaching Package', 'Coaching Packages');

        //View
        $permissions->registerPermission('ViewAllCoachingStaff', 'View All Coaching Staff', 'Coaching Staff');
        $permissions->registerPermission('ViewSalesTeamCoachingStaff', 'View All Sales Coaching Staff', 'Coaching Staff');
        $permissions->registerPermission('ViewTeamCoachingStaff', 'View Team Coaching Staff', 'Coaching Staff');

        //Create/Update
        $permissions->registerPermission('CreateTeamLeader', 'Create Team Leader', 'Coaching Staff');
        $permissions->registerPermission('CreateCoachingStaff', 'Create Coaching Staff', 'Coaching Staff');

        //Delete
        $permissions->registerPermission('DeleteTeamLeader', 'Delete Team Leader', 'Coaching Staff');
        $permissions->registerPermission('DeleteCoachingStaff', 'Delete Coaching Staff', 'Coaching Staff');

        //Report permissions
        $permissions->registerPermission('ViewOwnReports', 'View Own Evaluations', 'Coaching Reports');
        $permissions->registerPermission('ViewTeamReports', 'View Team Evaluations', 'Coaching Reports');
        $permissions->registerPermission('ViewCompanyReports', 'View Company Evaluations', 'Coaching Reports');
    }

    public function registerHooks(){
        Hook::registerCallback('entityLoadMultipleQuery', accessControl::class.':entityLoadMultipleQuery');
        Hook::registerCallback('entityLoadMultipleFields', accessControl::class.':entityLoadMultipleFields');
        Hook::registerCallback('entityLoadFields', accessControl::class.':entityLoadFields');
        Hook::registerCallback('entityLoadQuery', accessControl::class.':entityLoadQuery');
        Hook::registerCallback('entityAccess', accessControl::class.':entityAccess');
        Hook::registerCallback('userPostSave', userPostSave::class.':alter');
    }

    public function install(){
        $currentUser = currentUser::getCurrentUser();
        if(!$this->database){
            $this->database = Vault::getInstance();
        }
        $this->database->insert('roles')->fields(
            [
                'name' => "Sales Manager",
                'permissions' => serialize([]),
                'created' => time(),
                'created_by' => $currentUser->id,
                'modified' => time(),
                'modified_by' => $currentUser->id
            ]
        )->execute();

        $this->database->insert('roles')->fields(
            [
                'name' => "Team Leader",
                'permissions' => serialize([]),
                'created' => time(),
                'created_by' => $currentUser->id,
                'modified' => time(),
                'modified_by' => $currentUser->id
            ]
        )->execute();

        $this->database->insert('roles')->fields(
            [
                'name' => "Staff Member",
                'permissions' => serialize([]),
                'created' => time(),
                'created_by' => $currentUser->id,
                'modified' => time(),
                'modified_by' => $currentUser->id
            ]
        )->execute();
    }
}