<?php

namespace apexl\Io\modules\coachingForms\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\coachingForms\entities\coachingFormsEntity;
use apexl\Io\modules\coachingForms\entities\packagesEntity;
use apexl\Io\modules\coachingForms\entities\questionsEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

/**
 * Class manageCoachingPackagesController
 * @package apexl\Io\modules\coachingForms\controllers
 */
class manageCoachingPackagesController extends Controller{

    /**
     * Get all available packages
     * @route GET /api/data/coaching-packages[/{id}]
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     */
    public function getPackages(Request $request, Response $response, $args){
        return $this->getEntityData($request, $response, $args, (new packagesEntity()));
    }

    /**
     * Create/update a package.
     * @route PUT|POST /api/data/coaching-packages[/{id}]
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     * @throws \Exception
     */
    public function storePackage(Request $request, Response $response, $args){
        $body = $request->getParsedBody();
        //first, store the package(s)
        foreach($body->SkyCoachingForms as $package) {
            $packageEntity = new packagesEntity();
            if($id = $args['id'] ?? FALSE){
                $packageEntity->load($id);
            }

            $packageEntity->name = $package->name;
            $packageEntity->active = 1;
            $packageEntity->store();
            //next, store the questions.
            foreach($package->questions as $key => $question) {
                $questionEntity = new questionsEntity();
                if($id){
                    $questionEntity->load($key);
                }
                $questionEntity->parentId = $packageEntity->id;
                $questionEntity->parentType = 'packages';
                $questionEntity->name = $question;
                $questionEntity->required = 0; //@todo do we need this? its not currently used
                $questionEntity->score = is_array($package->scores) ? $package->scores[$key] : $package->scores->$key; //@todo do we need this? its not currently used
                $questionEntity->store();
            }
        }

        //all done? Tell the user and redirect to the main view page for manage forms
        return System::asJson($response, System::output(['type' => 'success', 'content' => $packageEntity->name.' created'], "/coaching/manage"));
    }

    /**
     * Delete a package
     * @route /api/data/coaching-packages/{id}/delete
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     * @throws \Exception
     */
    public function deletePackage(Request $request, Response $response, $args){
        $package = new packagesEntity();
        $name =  $package->name;
        $package->delete($args['id']);
        return System::asJson($response, System::output(['type' => 'success', 'content' => 'Package '. $name.' '. 'deleted'], "/coaching/manage"));
    }
}