<?php

namespace apexl\Io\modules\coachingForms\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\coachingForms\entities\operators\coachingAnswersEntityOperator;

class coachingAnswersEntity extends Entity {

    public $questions = [];
    public $categories = [];

    public function __construct()
    {
        parent::__construct('complete_form');
        $this->setOperator(new coachingAnswersEntityOperator('complete_form'));
    }

    public function load($id){
        parent::__call('load', [$id]);
        //next we need to load all answers as well
        if($id = $this->data['id'] ?? FALSE){
            //get the categories
            $coachingForm = new coachingFormsEntity();
            $coachingForm->load($this->data['form_id']);
            $this->categories = $this->groupDataForScoring($coachingForm->getCategories(), $id);
        }
    }

    /**
     * @param $categories
     * @param null $coachingForm
     * @param array $args
     * @param false $ignoreAccessControl
     * @return array
     */
    public static function groupDataForScoring($categories, $coachingForm = NULL, $args = [], $ignoreAccessControl = false){
        $categoryScores = [];
        foreach($categories as $cat) {
            //we need to check for existing data. if this has already been processed this is a company run, in which case strip added 999 from the id for packages.
            if(isset($cat->isPackage) && ($cat->isPackage)){
                $cat->id = substr($cat->id, 3);
            }
            $questionsEntity = new questionsEntity();
            $questionAnswers = $questionsEntity->getAnswersByCompletedFormCategory($cat->id, $coachingForm, $args, ($cat->table ?? 'form_categories'), $ignoreAccessControl);

            //exclude unselected packaged from reports
            if(isset($cat->table) && $cat->table == 'packages' && empty($questionAnswers)){
                continue;
            }

            //to prevent ID collisions prepend packages with 999
            if(isset($cat->table) && $cat->table == 'packages'){
                $cat->id = '999'.$cat->id;
            }

            //calculateCategoryScore
            $catScores = self::calculateCategoryScores($questionAnswers);
            $catScore = number_format($catScores['score']);

            $categoryScores[$cat->id] = $cat;
            $categoryScores[$cat->id]->catScores = (object)[];
            $categoryScores[$cat->id]->catScores->scoreText = $catScore . '%';
            $categoryScores[$cat->id]->catScores->score = $catScore;
            $categoryScores[$cat->id]->isNA = false; //assume false unless we set to true below.
            $categoryScores[$cat->id]->isPackage = isset($cat->table) && $cat->table == 'packages'; //assume false unless we set to true below.

            foreach ($questionAnswers as $answers) {
                $categoryScores[$cat->id]->questions[$answers->question_id] = (object)[
                    'name' => $answers->questionText,
                    'demonstrated_raw' => $answers->demonstrated,
                    'demonstrated' => $questionsEntity::demonstratedToText($answers->demonstrated),
                    'comment' => $answers->comments,
                    'score' => number_format($catScores['questions'][$answers->question_id]['score']),
                    'isNA' => number_format($catScores['questions'][$answers->question_id]['isNA'])
                ];
                $categoryScores[$cat->id]->isNA = !$categoryScores[$cat->id]->isNA ? $catScores['questions'][$answers->question_id]['isNA'] : $categoryScores[$cat->id]->isNA;
            }
        }
        return $categoryScores;
    }
    //calculate the scores
    public static function calculateCategoryScores($questions)
    {
        //loop over questions, total scores, calc % based on totals, ignore N/A
        $scoreTotal = 0;
        $scoreActual = 0;

        $categoryScores = [];
        $questionScores = [];
        $questionIsNA = TRUE;
        foreach($questions as $question){
            if(!isset($questionScores[$question->question_id])){
                $questionScores[$question->question_id]['total'] = 0;
                $questionScores[$question->question_id]['actual'] = 0;
            }

            if($question->demonstrated != 3){
                $questionIsNA = FALSE;
                $scoreTotal = $scoreTotal + $question->score;
                $questionScores[$question->question_id]['total'] = $questionScores[$question->question_id]['total'] + $question->score;
                if($question->demonstrated == 1){
                    $scoreActual = $scoreActual + $question->score;
                    $questionScores[$question->question_id]['actual'] = $questionScores[$question->question_id]['actual'] + $question->score;
                }
            }
            //update on every loop so we dont have to loop again.
            $questionScores[$question->question_id]['score'] = $questionScores[$question->question_id]['total'] != 0 ? ($questionScores[$question->question_id]['actual']/$questionScores[$question->question_id]['total'])*100 : 0;
            $questionScores[$question->question_id]['isNA'] = $questionIsNA;
        }
        $categoryScores['score'] = $scoreTotal != 0 ? ($scoreActual/$scoreTotal)*100 : 0;
        $categoryScores['questions'] = $questionScores;
        return $categoryScores;
    }

    public static function statusText($status): string
    {
        switch($status){
            case 0:
                return "Draft";
            case 1:
                return "Published";
            case 2:
                return "Reviewed";
        }
        return "Unknown";
    }

    public function delete($id = null){
        //get all answers for this, then delete them.
        $this->operator->deleteFormAnswers($id ?? $this->id);
        return parent::delete($id);
    }
}