<?php

namespace apexl\Io\modules\coachingForms\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class coachingAnswersEntityOperator extends entityDatabaseOperator{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function storeQuestionAnswer($questionId, $formId, $demonstrated, $comments){
        //first, we need to check if this question has an answer for this coaching record.
        //NOTE form)id is missnamed here, it is actually the answers id **NOT** the id of the form being submitted, but the specific coaching answers entity.
        $exists = $this->vault->select('complete_form_answers')->fields()->where('question_id', $questionId)->where('form_id', $formId)->execute()->fetchAssoc();
        if(isset($exists['id'])){
            return $this->vault->update('complete_form_answers')->fields(
                [
                    'demonstrated' => $demonstrated,
                    'comments' => $comments,
                    'completed_date' => time()
                ]
            )->where('id', $exists['id'])->execute();
        } else {
            return $this->vault->insert('complete_form_answers')->fields(
                [
                    'question_id' => $questionId,
                    'form_id' => $formId,
                    'demonstrated' => $demonstrated,
                    'comments' => $comments,
                    'completed_date' => time()
                ]
            )->execute();
        }
    }

    public function getAnswers($formId){
        return $this->vault->select('complete_form_answers')->fields()->where('form_id', $formId)->execute()->fetchAll();
    }

    public function deleteFormAnswers($formId){
        return $this->vault->delete('complete_form_answers')->where('form_id', $formId)->execute();
    }
}