<?php

namespace apexl\Io\modules\coachingForms\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class coachingFormsEntityOperator extends entityDatabaseOperator{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getActiveForm(){
        return $this->vault->select($this->dbTable)->fields()->where('active', 1)->execute()->fetchAssoc();
    }

    public function getCategories($formId){
        return $this->vault->select('form_categories')->fields()->where('parentId', $formId)->execute()->fetchAll();
    }

    public function addPackage($formId, $id){
        return $this->vault->insert('form_packages')->fields(['formId' => $formId, 'packageId' => $id])->execute();
    }

    public function getPackages($formId){
        return $this->vault->select('form_packages')->fields()->where('formId', $formId)->execute()->fetchAll();
    }

    public function turnOffForms(){
        //update all forms to mark them inactive.
        return $this->vault->update($this->dbTable)->fields(['active' => 0])->execute();
    }
}