<?php

namespace apexl\Io\modules\coachingForms\entities\operators;

use apexl\Io\modules\user\services\currentUser;
use apexl\Io\operators\entityDatabaseOperator;

class questionsEntityOperator extends entityDatabaseOperator{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getCategoryQuestions($categoryId){
        return $this->vault->select($this->dbTable)->fields()->where('parentId', $categoryId)->where('parentType', 'form_categories')->execute()->fetchAll();
    }

    public function getPackageQuestions($packageId){
        return $this->vault->select($this->dbTable)->fields()->where('parentId', $packageId)->where('parentType', 'packages')->execute()->fetchAll();
    }

    /**
     * @param $catId
     * @param null $completedFormID
     * @param array $args
     * @param string $type
     * @param bool $ignoreAccessControl
     * @return mixed
     * SQL Generated::
     * SELECT form_questions.name as questionText, form_questions.score, complete_form_answers.*, form_categories.* FROM complete_form_answers
     * JOIN form_questions ON form_questions.id = question_id
     * JOIN form_categories on form_questions.parentId = form_categories.id
     * JOIN users on users.id = complete_form_answers.staff_id
     * WHERE parentType = $type
     * AND form_categories.id = $catId
     * AND complete_form_answers.form_id = $completedFormID
     */
    public function getAnswers($catId, $completedFormID = null, $args = [], $type = 'form_categories', $ignoreAccessControl = FALSE){
        $currentUser = currentUser::getCurrentUser();
        $fields = [];
        $fields[] = 'form_questions.name as questionText';
        $fields[] = 'form_questions.score';
        $fields[] = 'complete_form_answers.*';
        if($type == 'form_categories') {
            $fields[] = 'form_categories.*';
        } else {
            $fields[] = 'packages.*';
        }
        $query = clone $this->vault->select('complete_form_answers')
            ->fields($fields)
            ->join('form_questions', 'form_questions.id', 'question_id');
        if($type == 'form_categories') {
            $query->join('form_categories', 'form_questions.parentId', 'form_categories.id');
        } else {
            $query->join('packages', 'form_questions.parentId', 'packages.id');
        }
        $query->join('complete_form', 'complete_form.id', 'complete_form_answers.form_id')
            ->join('users', 'users.id', 'complete_form.staff_id')
            ->join('coaching_teams cts', 'cts.user_id', 'staff_id');

        if(($currentUser->isAllowed('ViewCompanyReports') || $currentUser->isAllowed('ViewSalesTeamCoachingStaff')) || $ignoreAccessControl) {
            $query->leftJoin('coaching_teams ctt', 'ctt.team_leader_id', 'cts.user_id');
        }
        $query->where('form_questions.parentType', $type);
        if($type == 'form_categories') {
            $query->where('form_categories.id', $catId);
        } else {
            $query->where('packages.id', $catId);
        }
        if($completedFormID) {
            $query->where('complete_form_answers.form_id', $completedFormID);
        } else {
            if($currentUser->isAllowed('ViewAllCoachingStaff') || $ignoreAccessControl){

            } else {
                //limit to team results if we're a team user, otherwise, load everything.
                $query->where('complete_form.team_leader_id', $currentUser->id, '=', 'AND (')
                    ->where('complete_form.staff_id', $currentUser->id, '=', 'OR', ')');
            }

        }
        if(!empty($args)){
            foreach($args as $arg => $values){
                $query->where($values[0], $values[1], $values[2], $values[3] ?? 'AND', $values[4] ?? '');
            }
        }
        return $query->execute()->fetchAll();
    }
}