<?php

namespace apexl\Io\modules\coachingForms\entities\operators;

use apexl\Io\modules\user\services\currentUser;
use apexl\Io\operators\entityDatabaseOperator;

class teamEntityOperator extends entityDatabaseOperator{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function loadByMember($userId){
        $entity = $this->vault->select($this->dbTable)->fields()->where('user_id', $userId)->execute()->fetchAssoc();
        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function getTeamByLeader($userId){
        return $this->vault->select($this->dbTable)->fields()->where('team_leader_id', $userId)->execute()->fetchAll();
    }

    public function getAllTeamLeaders(){
        return $this->vault->select($this->dbTable)->fields('users.*')
            ->join('users', 'users.id', 'team_leader_id')
            ->groupBy('team_leader_id')
            ->orderBy('last_name', 'ASC')->execute()->fetchAll();
    }

    public function getEvaluationsByState($args = []){
        $currentUser = currentUser::getCurrentUser();
        $query = clone $this->vault->select($this->dbTable)
            ->fields([$this->dbTable.'.team_leader_id', 'state', 'count(state) as numEvaluations'])
            ->join('complete_form', 'staff_id', 'user_id')
            ->join('users', 'users.id', 'staff_id');
        if($currentUser->isAllowed('ViewCompanyReports') || $currentUser->isAllowed('ViewSalesTeamCoachingStaff')) {
            //no need to do anything.
            $query->leftJoin('coaching_teams ctt', 'coaching_teams.team_leader_id', 'coaching_teams.user_id');
        } else if($currentUser->isAllowed('ViewTeamReports')) {
            $query->where($this->dbTable.'.team_leader_id', $currentUser->id);
        } else {
            $query->where('staff_id', $currentUser->id);
        }
        if(!empty($args)){
            foreach($args as $arg => $values){
                //already applied staff and team leader filters, so ignore them.
                if($values[0] == 'complete_form.team_leader_id' || $values[0] == 'complete_form.staff_id'){
                    continue;
                }

                $query->where($values[0], $values[1], $values[2], $values[3] ?? 'AND', $values[4] ?? '');
            }
        }
        $query->groupBy('coaching_teams.team_leader_id, state');

        return $query->execute()->fetchall();
    }
}