<?php

namespace apexl\Io\modules\coachingForms\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\coachingForms\entities\operators\questionsEntityOperator;

class questionsEntity extends Entity {

    public function __construct()
    {
        parent::__construct('form_questions');
        $this->setOperator(new questionsEntityOperator('form_questions'));
    }

    /**
     * @param $catId
     * @param null $completedFormID
     * @param array $args
     * @param string $type
     * @param bool $ignoreAccessControl
     * @return array
     */
    public function getAnswersByCompletedFormCategory($catId, $completedFormID, $args = [], $type = 'form_categories', $ignoreAccessControl = FALSE): array
    {
        return $this->operator->getAnswers($catId, $completedFormID, $args, $type, $ignoreAccessControl);
    }

    public static function demonstratedToText($val){
        switch ($val){
            case 'true':
            case 1:
                return 'true';
            case 'false':
            case 2:
                return 'false';
            case 'N/A':
            case 3:
            default:
            return 'na';
        }
    }

    public static function demonstratedToReadable($val){
        switch ($val){
            case 'true':
            case 1:
                return 'Yes';
            case 'false':
            case 2:
                return 'No';
            case 'N/A':
            case 3:
            default:
                return 'N/A';
        }
    }
}