<?php

namespace apexl\Io\modules\coachingFormsDisplay\callbacks;

use apexl\Io\modules\coachingForms\entities\coachingAnswersEntity;
use apexl\Io\modules\coachingForms\entities\teamEntity;
use apexl\Io\modules\user\entities\roleEntity;

class EntityCallbacks {
    public function entityPreDelete($entity, $entityName){
        switch($entityName){
            case 'userEntity':
                if($entity) {
                    //force a full load.
                    $entity->load($entity->id);
                    //if we're deleting a user, make sure we delete associated entities, but only for staff members for now.
                    //load role
                    $role = new roleEntity();
                    //limited to staff members to avoid assignment issues.
                    $role->loadByName("Staff Member");
                    $tlRole = new roleEntity();
                    $tlRole->loadByName("Team Leader");
                    if ($entity->hasRole($role->id) && !$entity->hasRole($tlRole->id)) {
                        //delete everything related to this staff member.
                        //get all completed forms
                        $completedForms = new coachingAnswersEntity();
                        //foreach form, delete its answers and the complete record.
                        $staffForms = $completedForms->loadMultiple(['staff_id' => ['staff_id', $entity->id]]);
                        foreach ($staffForms as $form){
                            $form->delete();
                        }
                        //delete any team join records
                        $team = new teamEntity();
                        $team->loadByMember($entity->id);
                        $team->delete();
                    } else {
                        $entity = FALSE;
                    }
                }
                break;
        }
        return $entity;
    }
}