<?php

namespace apexl\Io\modules\coachingFormsDisplay\callbacks;

use apexl\Io\modules\coachingForms\entities\teamEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\markupField;
use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;

class displayFormRender {
    /**
     * CALLBACK
     * @param formEntity $form
     * @param $user
     * @param string $formName
     * @return formEntity
     * @throws \Exception
     * @see io-display module /pages/genericPage.php wrapper() method.
     */
    public static function alter(formEntity $form, $user, string $formName): formEntity
    {
        //Only do this is the patch matches
        switch($formName){
            case 'userEditForm':
                //we need to add a team field to the form.
                $teamLeaderSelectLabel = (new markupField('team_leader_label', 'Team Leader:'))->addClass('user_form_tl col-md-2 bmd-form-group');

                //First get the current user's available staff.
                //If we're updating a form, dont allow the staff member to be changed.
                $roles = new roleEntity();
                $roles->loadByName("Team Leader");

                //note quotations here are deliberate to make sure we match serialised data contents, not keys.
                $currentUser = currentUser::getCurrentUser();
                //check for default selection
                $currentTeam = null;
                if(isset($user->id)) {
                    $currentTeam = new teamEntity();
                    $currentTeam->loadByMember($user->id);
                }

                if($currentUser->isAllowed('CreateTeamLeader')) {
                    $teamLeaders = $currentUser->getUsersByRoleName("Team Leader");
                    $options = [];
                    if (!empty($teamLeaders)) {
                        foreach ($teamLeaders as $teamLeader) {
                            $options[$teamLeader->id] = $teamLeader->last_name . ',' . $teamLeader->first_name;
                        }
                    }
                    $selectField = (new selectField('team_leader', $options))->addClass('col-md-3');
                    if($currentTeam->id ?? FALSE){
                        $selectField->setValue($currentTeam->team_leader_id);
                    }
                } else {
                    if($currentTeam->id ?? FALSE) {
                        $selectField = (new inputField('team_leader', 'hidden'))->setValue($currentTeam->team_leader_id);
                        $tlUser = new userEntity();
                        $tlUser->load($currentTeam->team_leader_id, TRUE);
                        $selectFieldMarkup = (new markupField('team_leader_markup', $tlUser->last_name. ',' .$tlUser->first_name))->addClass('col-md-3 bmd-form-group');
                    }
                }

                $form->addFieldToGroup($teamLeaderSelectLabel,'team_leader_group');
                if($selectFieldMarkup ?? FALSE) {
                    $form->addFieldToGroup($selectFieldMarkup, 'team_leader_group');
                }
                $form->addFieldToGroup($selectField,'team_leader_group');
                break;
        }
        return $form;
    }
}