<?php

namespace apexl\Io\modules\coachingFormsDisplay\callbacks;

use apexl\Io\modules\coachingForms\entities\coachingAnswersEntity;
use apexl\Io\modules\coachingFormsDisplay\components\dashboardTiles;
use apexl\Io\modules\coachingFormsDisplay\pages\manageForms;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\services\pathUtility;

class genericWrapperAlter {
    /**
     * CALLBACK
     * @param $component | array
     * @param $componentName
     * @return componentEntity
     * @see io-display module /pages/genericPage.php wrapper() method.
     */
    public static function alter($component, $componentName)
    {
        //Only do this is the patch matches
        $path = pathUtility::getInstance();
        switch($componentName){
            case 'TitleTile':
                $url = $path->getPath();
                switch($url){
                    case 'coaching/add-new':
                        $component->addProperty('title', "Coaching Forms");
                        break;
                    case 'coaching/manage/create-form':
                        $component->addProperty('title', "Manage Coaching Forms");
                        break;
                    case 'coaching/manage/create-package':
                        $component->addProperty('title', "Manage Coaching Packages");
                        break;
                    case '':
                        $component->addProperty('title', "");
                        break;
                }
                //no breadcrumbs on this platform, so remove them. @todo maybe add this to config instead so we can avoid building them in the first place?
                $component->removeProperty('breadcrumbs');
                break;
            case 'PreContentComponents':
                $url = $path->getPath();
                switch($url){
                    case 'coaching/manage':
                    case 'coaching/manage/view':
                        $component[] = (new manageForms())->manageFormToolbar();
                        break;
                    case 'coaching/manage/create-form':
                        $component[] = (new manageForms())->manageFormToolbarAddCoachingForm();
                        break;
                    case 'coaching/manage/create-package':
                        $component[] = (new manageForms())->manageFormToolbarAddPackagesForm();
                        break;
                    case 'coaching/add-new':
                        $component[] = (new manageForms())->manageFormAddNew();
                        break;
                }

                //add toolbar for edit pages
                if($path->getPath(0) == 'coaching' && $path->getPath(2) == 'edit'){
                    $component[] = (new manageForms())->manageFormAddNew();
                }
                if($path->getPath(0) == 'reports' && $path->getPath(1) == 'view-report' && !empty($path->getPath(2))){
                    $record = new coachingAnswersEntity();
                    $record->load($path->getPath(2));
                    if($record->state != 2) {
                        $component[] = (new manageForms())->viewReport($path->getPath(2));
                    } else {
                        $component[] = (new manageForms())->exportReport();
                    }
                }
                break;
            case 'DashboardHomeAlter':
                //we need to return our tiles here.
                $rowWrapper = genericComponents::rowWrapper('dashboard-wrapper col-sm-12');
                $rowWrapper->addComponent(dashboardTiles::dashboardCompletedEvaluations());
                $rowWrapper->addComponent(dashboardTiles::dashboardRecentEvaluations());
                $rowWrapper->addComponent(dashboardTiles::dashboardBreakdownbycoach());
                $rowWrapper->addComponent(dashboardTiles::dashboardGraph());
                $component = [$rowWrapper];
                break;
        }
        return $component;
    }
}