<?php

namespace apexl\Io\modules\coachingFormsDisplay\callbacks;

use apexl\Io\modules\coachingForms\entities\coachingAnswersEntity;
use apexl\Io\modules\coachingForms\entities\teamEntity;
use apexl\Io\modules\user\entities\userEntity;

class getEntityDataAlter {
    public static function alter($entityData, $entityName){
        switch($entityName){
            case "coachingAnswersEntity":
                $entityData['tableHeader'] = [
                    'ID',
                    'Date',
                    'Status',
                    'Staff Member',
                    'Manager',
                ];

                $alteredRows = [];
                foreach($entityData['rows'] as $entityID => $row){
                    $alteredRows[$entityID] = [];
                    $alteredRows[$entityID]['id'] = $row['id'];
                    //rebuild the row.
                    $alteredRows[$entityID]['completed_date'] = date('H:i d/m/Y', $row['completed_date']);
                    $alteredRows[$entityID]['state'] = coachingAnswersEntity::statusText($row['state']);
                    $user = new userEntity();
                    $user->load($row['staff_id']); //load staff
                    $alteredRows[$entityID]['staff_id'] = $user->last_name.', '.$user->first_name;
                    $teamLeader = new userEntity();
                    $teamLeader->load($row['team_leader_id'], TRUE); //replace load with manager
                    $alteredRows[$entityID]['team_leader_id'] = $teamLeader->last_name.', '.$teamLeader->first_name;
                }
                $entityData['rows'] = $alteredRows;
                break;
            case "userEntity":
                //TN overrides the base user override... Module waiting is important here, this needs to fire last in the process.
                $entityData['tableHeader'] = [
                    'User ID',
                    'First Name',
                    'Last Name',
                    'Email',
                    'Team',
                    'Last Login',
                    'Roles'
                ];

                $alteredRows = [];
                foreach($entityData['rows'] as $entityID => $row){
                    //get user's team.
                    $teamLeader = new teamEntity();
                    $teamLeader->loadByMember($row['id']);

                    $TLName = array('team' => '');
                    if($teamLeader->team_leader_id) {
                        //Team leader user
                        $user = new userEntity();
                        $user->load($teamLeader->team_leader_id);
                        $TLName = array('team' => $user->last_name.', '.$user->first_name);
                    }

                    $offset = 5;
                    $row = array_slice($row, 0, $offset, true) + $TLName + array_slice($row, $offset, NULL, true);

                    $alteredRows[$entityID] = $row;
                    unset($alteredRows[$entityID]['active']);
                    if(isset($alteredRows[$entityID]['coaching_id'])){
                        unset($alteredRows[$entityID]['coaching_id']);
                    }
                    if(isset($alteredRows[$entityID]['team_leader_id'])){
                        unset($alteredRows[$entityID]['team_leader_id']);
                    }
                    if(isset($alteredRows[$entityID]['user_id'])){
                        unset($alteredRows[$entityID]['user_id']);
                    }
                }
                $entityData['rows'] = $alteredRows;
                break;
        }
        return $entityData;
    }
}