<?php

namespace apexl\Io\modules\coachingFormsDisplay;

use apexl\Io\includes\Hook;
use apexl\Io\includes\Module;
use apexl\Io\modules\coachingForms\controllers\coachingRecordsController;
use apexl\Io\modules\coachingForms\controllers\manageCoachingFormsController;
use apexl\Io\modules\coachingForms\controllers\manageCoachingPackagesController;
use apexl\Io\modules\coachingFormsDisplay\callbacks\displayFormRender;
use apexl\Io\modules\coachingFormsDisplay\callbacks\EntityCallbacks;
use apexl\Io\modules\coachingFormsDisplay\callbacks\getEntityDataAlter;
use apexl\Io\modules\coachingFormsDisplay\components\filters;
use apexl\Io\modules\coachingFormsDisplay\controllers\callbackController;
use apexl\Io\modules\coachingFormsDisplay\controllers\coachingDisplayController;
use apexl\Io\modules\coachingFormsDisplay\callbacks\genericWrapperAlter;
use apexl\Io\modules\coachingFormsDisplay\controllers\manageCoachingFormsDisplayController;
use apexl\Io\modules\coachingFormsDisplay\controllers\manageCoachingPackagesDisplayController;
use apexl\Io\modules\coachingFormsDisplay\controllers\manageCoachingRecordsDisplayController;
use apexl\Io\modules\user\services\Permissions;

class coachingFormsDisplayModule extends Module {
    public function __construct()
    {
        parent::__construct();
        $this->registerHooks();
    }

    public function routes(){

        $routes = $this->route;

        //Top Level Menu routes
        $routes->get('/coaching', manageCoachingFormsDisplayController::class.':coachingParent', 'IsLoggedIn')->addToMenu("Coaching Forms", "");
        $routes->get('/coaching/view-all-forms', manageCoachingFormsDisplayController::class.':viewAllForms', 'ManageCoachingForms');
        $routes->get('/coaching/view-all-packages', manageCoachingPackagesDisplayController::class.':viewAllPackages', 'ManageCoachingForms');
        $routes->get('/coaching/add-new', manageCoachingRecordsDisplayController::class.':addNewCoachingRecord', 'CompleteCoachingForms')->addToMenu("Add New", "", '/coaching');
        $routes->get('/coaching/manage', manageCoachingFormsDisplayController::class.':manageCoachingForms', 'ManageCoachingForms')->addToMenu("Manage Forms Dashboard", "", '/coaching');
        $routes->get('/reports/view-report/{id}', manageCoachingRecordsDisplayController::class.':viewCoachingRecord', 'IsLoggedIn');
        $routes->get('/coaching/{id}/edit', manageCoachingRecordsDisplayController::class.':addNewCoachingRecord', 'CompleteCoachingForms');
        //$routes->get('/coaching/{id}/view', manageCoachingRecordsDisplayController::class.':viewCoachingRecord', 'IsLoggedIn');
        $routes->get('/reports', manageCoachingRecordsDisplayController::class.':viewAllCoachingRecords', 'IsLoggedIn')->addToMenu("Reports", "");
        $routes->get('/reports/all-evaluations', manageCoachingRecordsDisplayController::class.':viewAllEvaluations', 'AccessCoachingReports')->addToMenu("View All", "", '/coaching');;
        $routes->get('/reports/{type}/components', manageCoachingRecordsDisplayController::class.':reportComponents', 'IsLoggedIn');
        //NOTE Hacky way to avoid single dropdown menu items.
        $routes->get('/reports/{type}/evaluations', manageCoachingRecordsDisplayController::class.':viewAllEvaluations', 'IsLoggedIn');
        $routes->get('/reports/{type}', manageCoachingRecordsDisplayController::class.':viewAllCoachingRecords', 'IsLoggedIn');
        //Coaching Form Management links
        //grouping doesnt seem to work, so cheat :D
        $group = '/coaching/manage';
        $routes->get($group.'/packages/{id}/delete', manageCoachingPackagesDisplayController::class.':managePackagesDeleteView', 'DeleteCoachingPackage');
        $routes->get($group.'/packages/{id}/edit', manageCoachingPackagesDisplayController::class.':manageCreatePackage', 'ManageCoachingForms');
        $routes->get($group.'/form/{id}/edit', manageCoachingFormsDisplayController::class.':createCoachingForms', 'ManageCoachingForms');
        $routes->get($group.'/form/{id}/delete', manageCoachingFormsDisplayController::class.':manageFormsDeleteView', 'ManageCoachingForms');
        $routes->get($group.'/create-form', manageCoachingFormsDisplayController::class.':createCoachingForms', 'ManageCoachingForms');
        $routes->get($group.'/create-package', manageCoachingPackagesDisplayController::class.':manageCreatePackage', 'ManageCoachingForms');

        //Form Layout Routes
        $group = '/api/display/forms/coaching';
        $routes->get($group.'/packages/{id}/delete', manageCoachingPackagesDisplayController::class.':packagesDeleteForm', 'DeleteCoachingPackage');
        $routes->get($group.'/forms/{id}/delete', manageCoachingFormsDisplayController::class.':formsDeleteForm', 'DeleteCoachingPackage');
        $routes->get($group.'/manageForm/{id}/edit', manageCoachingFormsDisplayController::class.':manageCreateForm', 'ManageCoachingForms');
        $routes->get($group.'/manageForm', manageCoachingFormsDisplayController::class.':manageCreateForm', 'ManageCoachingForms');
        $routes->get($group.'/managePackages', manageCoachingPackagesDisplayController::class.':createPackageForm', 'ManageCoachingForms');
        $routes->get($group.'/managePackages/{id}/edit', manageCoachingPackagesDisplayController::class.':createPackageForm', 'ManageCoachingForms');
        $routes->get($group.'/createNew', manageCoachingRecordsDisplayController::class.':coachingRecordForm', 'IsLoggedIn');
        $routes->get($group.'/createNew/{id}/edit', manageCoachingRecordsDisplayController::class.':coachingRecordForm', 'IsLoggedIn');

        //Form field Callbacks
        $group = '/api/display/callbacks';
        $routes->get($group.'/package/{id}[/{formId}]', callbackController::class.':getPackageFields', 'IsLoggedIn');
        $routes->get($group.'/reports-filter', filters::class.':reportingFilter', 'IsLoggedIn');
        $routes->get($group.'/question/{id}', callbackController::class.':questionInfo', 'IsLoggedIn');

        //POST routes for forms that cannot delete
        $group = '/api/data';
        $routes->post($group.'/coaching-forms/{id}', manageCoachingFormsController::class.':storeForm', 'ManageCoachingForms');
        $routes->post($group.'/coaching-forms/{id}/delete',manageCoachingFormsController::class.':deleteForm', 'ManageCoachingForms');
        $routes->post($group.'/coaching-packages/{id}', manageCoachingPackagesController::class.':storePackage', 'CreateCoachingPackage');
        $routes->post($group.'/coaching-packages/{id}/delete',manageCoachingPackagesController::class.':deletePackage', 'DeleteCoachingPackage');
        $routes->post($group.'/coaching-records/{id}', coachingRecordsController::class.':storeNewCoachingRecord', 'CompleteCoachingForms');
    }

    public function registerPermissions(Permissions $permissions)
    {
        $permissions->registerPermission('ManageCoachingForms', 'Manage Coaching Forms', 'Sky Coaching');
        $permissions->registerPermission('AccessCoachingReports', 'View All Coaching Reports', 'Sky Coaching');
    }

    protected function registerHooks(){
        Hook::registerCallback('entityPreDelete', EntityCallbacks::class.':entityPreDelete');
        Hook::registerCallback('genericWrapperAlter', genericWrapperAlter::class.':alter');
        Hook::registerCallback('getEntityData', getEntityDataAlter::class.':alter');
        Hook::registerCallback('displayFormRender', displayFormRender::class.':alter');
    }
}