<?php

namespace apexl\Io\modules\coachingFormsDisplay\components;

use apexl\Io\modules\coachingForms\entities\coachingAnswersEntity;
use apexl\Io\modules\coachingForms\entities\coachingFormsEntity;
use apexl\Io\modules\coachingForms\entities\packagesEntity;
use apexl\Io\modules\coachingForms\entities\questionsEntity;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\user\entities\userEntity;

class content
{
    public static function contentTitleTile()
    {
        //Into text
        $subtitle = new componentEntity();
        $subtitle->name = 'ContentTitle';
        $subtitle->addProperty('header', 3);
        return $subtitle;
    }

    public static function coachingFormsCreateNewTitle($args)
    {
        $subtitle = self::contentTitleTile();
        if ($id = $args['id'] ?? FALSE) {
            $form = new coachingFormsEntity();
            $form->load($args['id']);
            $subtitle->addProperty('title', 'Update ' . $form->name);
            $subtitle->addProperty('content', 'Please note only one coaching form can be active at any one time - selecting active on the form below will set this to the current active form.');
        } else {
            $subtitle->addProperty('title', 'Create new form');
            $subtitle->addProperty('content', 'Please note only one coaching form can be active at any one time - selecting active on the form below will set this to the current active form.');
        }
        return $subtitle;
    }

    public static function coachingFormsPackageCreateNewTitle($args)
    {
        $subtitle = self::contentTitleTile();
        if ($id = $args['id'] ?? FALSE) {
            $package = new packagesEntity();
            $package->load($args['id']);
            $subtitle->addProperty('title', 'Update ' . $package->name);
            $subtitle->addProperty('content', 'Packages are groups of fields that can optionally be filled on forms. You will need to create a package before you can add it to a coaching form for selection.');
        } else {
            $subtitle->addProperty('title', 'Create a new package');
            $subtitle->addProperty('content', 'Packages are groups of fields that can optionally be filled on forms. You will need to create a package before you can add it to a coaching form for selection.');
        }
        return $subtitle;
    }

    public static function coachingRecordDisplay($id)
    {
        $categoryComp = null;
        $completedForm = new coachingAnswersEntity();
        $completedForm->load($id);
        $userEntity = (new userEntity())->load($completedForm->staff_id);
        $evaluationTitle = genericComponents::ContentTitle($userEntity->getNiceName() . ' ' . date('H:i d/m/Y', $completedForm->completed_date), $completedForm::statusText($completedForm->state) . ' Evaluation');

        //get the form packages so we can load those answers as well.
        $packageEntity = new packagesEntity();
        $formPackages = $packageEntity->getFormPackages($completedForm->form_id);
        foreach ($formPackages as $formPackage) {
            $package = new packagesEntity();
            $package->load($formPackage->packageId);
            $completedForm->categories += $completedForm::groupDataForScoring([$package], $id);
        }

        $transactionId = genericComponents::ContentTitle('Transaction ID', $completedForm->transactionId);

        //build the content display. To do this we need to get the role permissions and loop over them.
        $evaluationsContent = genericComponents::rowWrapper('evaluation-wrapper');
        $evaluationsContent->addComponent($transactionId);
        $evaluationsContent->addComponent(dashboardTiles::evaluationScoresTile($completedForm->categories));

        $categoriesContent = genericComponents::rowWrapper('categories-wrapper');
        $categories = $completedForm->categories;
        foreach ($categories as $category) {
            $categoryComp = self::categoryFieldset($category);
            if ($questions = $category->questions ?? FALSE) {
                foreach ($questions as $question) {
                    $categoryComp->addComponent(
                        self::htmlComponent(
                            '<div class="question-name demonstrated-' . questionsEntity::demonstratedToText($question->demonstrated) . '">' . $question->name . '</div><div class="question-comment">' . $question->comment . '</div>',
                            'question-row'
                        )
                    );
                }
            }
            $categoriesContent->addComponent($categoryComp);
        }

        $strength = genericComponents::ContentTitle('Key Strengths', $completedForm->key_strengths, 3, 'contentTile__wysiwyg');
        $keyDev = genericComponents::ContentTitle('Key Development Areas', $completedForm->key_dev_areas,3, 'contentTile__wysiwyg');
        $agreedActions = genericComponents::ContentTitle('Agreed Actions', $completedForm->agreed_actions,3, 'contentTile__wysiwyg');

        $evaluationsContent->addComponent($categoriesContent);
        $evaluationsContent->addComponent($strength);
        $evaluationsContent->addComponent($keyDev);
        $evaluationsContent->addComponent($agreedActions);

        return genericComponents::dashboardBlockWrapper([
            $evaluationTitle,
            $evaluationsContent,
        ]);
    }

    public static function categoryFieldset($category)
    {
        $companyScores = coachingAnswersEntity::groupDataForScoring(array(clone $category), NULL, [], TRUE);
        $fieldSet = new componentEntity();
        $fieldSet->name = 'Fieldset';
        $fieldSet->classes = 'category-fieldset row category category-'.(strtolower(str_replace('_', '', $category->name))).' '. ($category->isNA ? ' category-valid-'.$category->isNA : '');
        $fieldSet->addProperty('legend', self::categoryScoreRow($category, $companyScores));
        return $fieldSet;
    }

    public static function categoryScoreRow($category, $companyScores)
    {
        //we need to get the average for the provided category across the whole company. As the process is access controlled we need to fudge it.


        $scoreNum = intval($category->catScores->scoreText);

        if ($scoreNum < 50) {
            $scoreColorClass = "category_width--red";
        } else if ($scoreNum >= 50 && $scoreNum < 80) {
            $scoreColorClass = "category_width--yellow";
        } else {
            $scoreColorClass = "category_width--green";
        }

        if(isset($category->table) && $category->table == 'packages'){
            $category->id = '999'.$category->id;
        }

        //Get question scores
        $categoryMarkup = '
            <div data-category-id="' . $category->id . '" data-open="false" class="category-row-wrapper">
                <div class="category-row col-md-3 col-sm-6">' . $category->name . '</div>
                <div class="col-md-9 col-sm-6 category_width ' . $scoreColorClass . '">
                <div class="company_average" style="left:'.$companyScores[$category->id]->catScores->scoreText.'"></div>
                    <span style="width:' . $category->catScores->scoreText . '">' . $category->catScores->scoreText . '</span>
                </div>
            </div>
            <div id="' . $category->id . '" class="category-subquestion-wrapper">';
        if(isset($category->questions)) {
            foreach ($category->questions as $question) {

                $subScoreNum = intval($question->score);

                if ($subScoreNum < 50) {
                    $scoreColorClass = "category_width--red";
                } else if ($subScoreNum >= 50 && $subScoreNum < 80) {
                    $scoreColorClass = "category_width--yellow";
                } else {
                    $scoreColorClass = "category_width--green";
                }

                $categoryMarkup .= '<div class="category-question-row question-na-'.$question->isNA.' category-id-' . $category->id . ' row col-sm-12"><div class="col-sm-9 '.($question->isNA ? "demonstrated-na" : "").'">' . $question->name . '</div><div class="col-sm-3 category_width ' . $scoreColorClass . '"><span style="width:' . $question->score . '%">' . $question->score . '%</span></div></div>';
            }
        }
        $categoryMarkup .= '</div>';

        return '<div class="category-score-wrapper row col-md-12">' . $categoryMarkup . '</div>';
    }

    public static function breakdownRow($coach, $data)
    {
        $user = new userEntity();
        $user->load($coach, true);
        return '<div class="col-sm-4">' . $user->getNiceName() . '</div><div class="col-sm-2">' . $data->draft . '</div><div class="col-sm-2">' . $data->published . '</div><div class="col-sm-2">' . $data->reviewed . '</div><div class="col-sm-2">' . ($data->reviewed + $data->published + $data->draft). '</div>';
    }

    public static function htmlComponent($content, $classes = '')
    {
        $html = new componentEntity();
        $html->name = 'ContentHtml';
        $html->classes = $classes;
        $html->addProperty('content', $content);
        return $html;
    }
}
