<?php
namespace apexl\Io\modules\coachingFormsDisplay\components;

use apexl\Io\modules\coachingForms\entities\categoriesEntity;
use apexl\Io\modules\coachingForms\entities\coachingAnswersEntity;
use apexl\Io\modules\coachingForms\entities\packagesEntity;
use apexl\Io\modules\coachingForms\entities\teamEntity;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\services\pathUtility;

class dashboardTiles {
    public static function dashboardCompletedEvaluations($args = []){
        $totalEvals = (new coachingAnswersEntity())->loadMultiple($args, ['id', 'DESC']);
        $numEvals = count($totalEvals);
        //latest Eval, we're ordered by newest first so grab the top item
        $latest = array_shift($totalEvals);
        $currentUser = currentUser::getCurrentUser();
        $tiles = [];
        $tiles[] = genericComponents::ContentTitle('Evaluations completed: '.$numEvals);
        $tiles[] = genericComponents::ContentTitle('Last evaluation completed: '.(isset($latest->completed_date) ? date('d-m-Y H:i', $latest->completed_date) : 'N/A'));

        //Setup out roles first, so we dont have to keep doing this.
        //Because a user might be able to see more than one report level, we override previous vars accordingly
        $ownReports = $teamReports = $companyReports = $latestEvaluationTable = '';
        $path = pathUtility::getInstance();
        $url = $path->getPath();

        switch($url) {
            case 'reports/individual/components':
                $ownReports = 'active';
                break;
            case 'reports/team/components':
                $teamReports = 'active';
                break;
            case 'reports/company/components':
                $companyReports = 'active';
                break;
            default:
                if ($currentUser->isAllowed('ViewOwnReports')) {
                    $ownReports = 'active';
                }
                if ($currentUser->isAllowed('ViewTeamReports')) {
                    $ownReports = '';
                    $teamReports = 'active';
                }
                if ($currentUser->isAllowed('ViewCompanyReports')) {
                    $ownReports = $teamReports = '';
                    $companyReports = 'active';
                }
                break;
        }

        $categoriesEntity = new categoriesEntity();
        $completedForms = $categoriesEntity->loadMultiple();

        $packages = new packagesEntity();
        $allPacks = $packages->loadMultiple();
        foreach($allPacks as $pack) {
            $completedForms[] = $pack;
        }
        $categories = coachingAnswersEntity::groupDataForScoring($completedForms, NULL, $args);

        $evaluationsContent = genericComponents::rowWrapper('evaluation-wrapper');
        $evaluationsContent->addComponent(dashboardTiles::evaluationScoresTile($categories));

        if(!empty($evaluationsContent)){
            $tiles[] = $evaluationsContent;
        }

        //tile footer
        $userButtonWrapper = genericComponents::rowWrapper('tile-footer');
        if($currentUser->isAllowed('ViewOwnReports')) {
            $userButtonWrapper->addComponent(genericComponents::simpleButtonLink('/reports/individual', 'Individual report', '', $ownReports));
        }
        if($currentUser->isAllowed('ViewTeamReports')) {
            $userButtonWrapper->addComponent(genericComponents::simpleButtonLink('/reports/team', 'Team report', '', $teamReports));
        }
        if($currentUser->isAllowed('ViewCompanyReports')) {
            $userButtonWrapper->addComponent(genericComponents::simpleButtonLink('/reports/company', 'Company report', '', $companyReports));
        }

        if(!empty($userButtonWrapper)){
            $tiles[] = $userButtonWrapper;
        }

        return genericComponents::dashboardBlockWrapper($tiles);
    }

    /**
     * @return componentEntity
     */
    public static function dashboardRecentEvaluations(): componentEntity
    {
        $tileTitle1 = genericComponents::ContentTitle('Recent Evaluations');
        $formTable = dataTables::manageCoachingRecordsList('?limit=10&orderBy[]=id&orderBy[]=DESC');
        $formTable->addProperty('basePath', '/reports/view-report');

        $formButtonWrapper = genericComponents::rowWrapper('tile-footer');
        $formButtonWrapper->addComponent(genericComponents::simpleButtonLink('/reports/all-evaluations', 'View all'));
        $formButtonWrapper->addComponent(genericComponents::simpleButtonLink('/coaching/add-new', 'Create a report'));

        //build tile
        return genericComponents::dashboardBlockWrapper([
            $tileTitle1,
            $formTable
        ]);
    }

    public static function dashboardBreakdownbycoach($args = []){
        $completedFormsEntity = new coachingAnswersEntity();
        $completed = $completedFormsEntity->loadMultiple($args);

        //loop over completed forms - depending on the view and the user we need to group the results.
        $breakdown = [];
        foreach($completed as $completeForm){
            if(!isset($breakdown[$completeForm->team_leader_id])){
                $breakdown[$completeForm->team_leader_id] = (object)[
                    'draft' => 0,
                    'published' => 0,
                    'reviewed' => 0,
                ];
            }
            switch($completeForm->state){
                case 0:
                    ++$breakdown[$completeForm->team_leader_id]->draft;
                    break;
                case 1:
                    ++$breakdown[$completeForm->team_leader_id]->published;
                    break;
                case 2:
                    ++$breakdown[$completeForm->team_leader_id]->reviewed;
                    break;
            }
        }

        //build tile
        $tileTitle1 = genericComponents::ContentTitle('Breakdown by coach', '', 5);
        $breakdownTile = genericComponents::rowWrapper('evaluation-totals-wrapper');
        $breakdownTile->addComponent(content::htmlComponent('<div class="col-sm-4">Coach</div><div class="col-sm-2">Draft</div><div class="col-sm-2">Published</div><div class="col-sm-2">Reviewed</div><div class="col-sm-2">Total</div>', 'row col-sm-12'));
        $html = '';
        foreach($breakdown as $coach => $data){
            $html .= content::breakdownRow($coach, $data);
        }
        $breakdownTile->addComponent(content::htmlComponent($html, 'row col-sm-12 breakdown tl-'.($coach ?? 0)));
        return genericComponents::dashboardBlockWrapper([
            $tileTitle1,
            $breakdownTile
        ]);
    }

    public static function dashboardGraph(){


        return genericComponents::dashboardBlockWrapper([

        ]);
    }

    public static function manageCoachingFormList(){
        $listTitle = genericComponents::ContentTitle('Created Coaching Forms', 'A list of all available coaching forms, Active form first.');
        $formTable = dataTables::manageCoachingFormsList('?limit=10&deleted=0&orderBy=active');

        $formButtonWrapper = genericComponents::rowWrapper('tile-footer');
        $formButtonWrapper->addComponent(genericComponents::simpleButtonLink('/coaching/view-all-forms', 'View all'));
        $formButtonWrapper->addComponent(genericComponents::simpleButtonLink('/coaching/manage/create-form', 'Create a form'));

        //build tile
        return genericComponents::dashboardBlockWrapper([
            $listTitle,
            $formTable,
            $formButtonWrapper
        ]);
    }

    public static function managePackageFormList(){
        $listTitle = genericComponents::ContentTitle('Available Packages', 'A list of all available coaching packages');
        $formTable = dataTables::manageCoachingFormsPackageList('?limit=10&orderBy=active');

        $formButtonWrapper = genericComponents::rowWrapper('tile-footer');
        $formButtonWrapper->addComponent(genericComponents::simpleButtonLink('/coaching/view-all-packages', 'View all'));
        $formButtonWrapper->addComponent(genericComponents::simpleButtonLink('/coaching/manage/create-package', 'Create a Package'));

        //build tile
        return genericComponents::dashboardBlockWrapper([
            $listTitle,
            $formTable,
            $formButtonWrapper
        ]);
    }

    public static function evaluationScoresTile($categories){
        $evaluationWrapper = genericComponents::rowWrapper('evaluation-totals-wrapper');
        $evaluationWrapper->addComponent(content::htmlComponent('<div class="col-md-3 col-sm-6">Category</div><div class="col-md-9 col-sm-6">%Demonstrated</div>', 'row col-sm-12'));
        foreach($categories as $cat){
            //company scores, use a clean object clone so we dont update references
            $globalCompanyCat = clone $cat;
            $companyScores = coachingAnswersEntity::groupDataForScoring(array($globalCompanyCat), NULL, [], TRUE);
            $evaluationWrapper->addComponent(content::htmlComponent(content::categoryScoreRow($cat, $companyScores), 'row category category-'.(strtolower(str_replace('_', '', $cat->name))). ' category-valid-'.$cat->isNA));
        }
        return $evaluationWrapper;
    }
}