<?php
namespace apexl\Io\modules\coachingFormsDisplay\components;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\user\services\currentUser;

class dataTables {
    public static function manageCoachingRecordsList($filters = ''){
        return self::RecordDataTableDisplayTile('/api/data/coaching-records'.$filters, '/coaching',TRUE, 'CompleteCoachingForms');
    }

    public static function manageCoachingFormsList($filters = ''){
        return self::DataTableDisplayTile('/api/data/coaching-forms'.$filters, '/coaching/manage/form', FALSE, 'ManageCoachingForms', 'ManageCoachingForms');
    }

    public static function manageCoachingFormsPackageList($filters = ''){
        return self::DataTableDisplayTile('/api/data/coaching-packages'.$filters, '/coaching/manage/packages', FALSE, 'CreateCoachingPackage', 'DeleteCoachingPackage');
    }

    public static function DataTableDisplayTile($dataSrc, $buttonRoute, $addViewButton = FALSE, $editRole = FALSE, $deleteRole = FALSE): componentEntity
    {
        $currentUser = currentUser::getCurrentUser();
        $table = genericComponents::dataTable($dataSrc);
        $table->addProperty('hideIdColumn', true);
        $table->addProperty('allowViewClick', $addViewButton);
        if ($addViewButton) {
            $table->addComponent(genericComponents::tableButton($buttonRoute, 'eye', '', 'table__btn table__btn-view','view'));
        }
        if($access = ($editRole ? $currentUser->isAllowed($editRole) : FALSE)) {
            $editProcessButton = genericComponents::tableButton($buttonRoute, 'edit', '', 'table__btn table__btn-edit', 'edit');
            $table->addComponent($editProcessButton);
        }
        if($access = ($deleteRole ? $currentUser->isAllowed($deleteRole) : FALSE)) {
            $deleteProcessButton = genericComponents::tableButton($buttonRoute, 'trash-alt', '', 'table__btn table__btn-delete', 'delete');
            $table->addComponent($deleteProcessButton);
        }
        return $table;
    }

    public static function RecordDataTableDisplayTile($dataSrc, $buttonRoute, $addViewButton = FALSE, $editRole = FALSE): componentEntity
    {
        $currentUser = currentUser::getCurrentUser();
        $table = genericComponents::dataTable($dataSrc);
        $table->addProperty('hideIdColumn', true);
        $table->addProperty('allowViewClick', $addViewButton);
        if ($addViewButton) {
            $table->addComponent(genericComponents::tableButton('/reports/view-report', 'eye', '', 'table__btn table__btn-view',''));
        }
        if($access = ($editRole ? $currentUser->isAllowed($editRole) : FALSE)) {
            $editProcessButton = self::skyRecordsTableButton($buttonRoute, 'edit', '', 'table__btn table__btn-edit', 'edit');
            $table->addComponent($editProcessButton);
        }
        return $table;
    }

    public static function skyRecordsTableButton($route, $icon = NULL, $text = '', $classes = '', $event = ''){
        $tile = new componentEntity();
        $tile->id = $id ?? $tile->id;
        $tile->name = 'SkyRecordsTableButton';
        $tile->classes = $classes;
        $tile->addProperty('route', $route);
        $tile->addProperty('icon', $icon);
        $tile->addProperty('text', $text);
        $tile->addProperty('event', $event);

        return $tile;
    }
}