<?php

namespace apexl\Io\modules\coachingFormsDisplay\components;

use apexl\Io\includes\System;
use apexl\Io\modules\coachingForms\entities\teamEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\datePickerField;
use apexl\Io\modules\formbuilder\includes\markupField;
use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class filters {
    public function reportingFilter(Request $request, Response $response) {
        $form = new formEntity();
        $form->setId('reportingFilter');
        $form->setMethod('post');
        $form->setActionUrl('/api/callbacks/reports');
        $form->setSubmitText('Filter');
        $form->includeClearButton(TRUE)->setClearButtonText('Reset');

        $staffMembers = (new userEntity())->loadMultiple([], ['last_name', 'ASC']);
        $staffOptions = [];
        foreach($staffMembers as $staff){
            $staffOptions[$staff->id] = $staff->last_name .', '. $staff->first_name;
        }

        $staffSelectField = (new selectField('staff_id', $staffOptions))->addClass('col-md-4');

        $currentUser = currentUser::getCurrentUser();
        if($currentUser->isAllowed('ViewTeamReports') || $currentUser->isAllowed('ViewCompanyReports')) {
            $form->addFieldToGroup(($staffSelectField)->setLabel('Filter by Staff Member:')->addClass('report_filter report_filter__staff'), 'team');
        }
        if($currentUser->isAllowed('ViewCompanyReports')) {
            //get teamleaders
            $teams = new teamEntity();
            $leaders = $teams->getAllTeamLeaders();
            $teamOptions = [];
            $userEntity = new userEntity();
            foreach($leaders as $leader){
                $userEntity->load($leader->id); //we have to load the entity to do a perm check.
                //made sure we dont include SM's in this filter.
                if(!$userEntity->isAllowed('ViewAllCoachingStaff') && !$userEntity->isAllowed('ViewSalesTeamCoachingStaff')) {
                    $teamOptions[$leader->id] = $leader->last_name . ', ' . $leader->first_name;
                }
            }
            $teamSelectField = (new selectField('team_leader_id', $teamOptions))->addClass('col-md-4');
            $form->addFieldToGroup(($teamSelectField)->setLabel('Filter by Team:')->addClass('report_filter report_filter__team'), 'team');
        }
        if($currentUser->isAllowed('ViewCompanyReports') || $currentUser->isAllowed('ViewAllCoachingStaff') || $currentUser->isAllowed('ViewSalesTeamCoachingStaff')){
            $teams = new teamEntity();
            $leaders = $teams->getAllTeamLeaders();
            $smOptions = [];
            $userEntity = new userEntity();
            $smRole = new roleEntity();
            $smRole->loadByName('Sales Manager');
            foreach($leaders as $leader){
                $userEntity->load($leader->id);
                //made sure we only include SM's in this filter.
                if(in_array($smRole->id, $userEntity->roles)) {
                    $smOptions[$leader->id] = $leader->last_name . ', ' . $leader->first_name;
                }
            }
            $teamSelectField = (new selectField('sales_manager_id', $smOptions))->addClass('col-md-4');
            $form->addFieldToGroup(($teamSelectField)->setLabel('Filter by Sales Manager:')->addClass('report_filter report_filter__team'), 'team');
        }
        $form->addFieldToGroup((new markupField('from_label', 'From: '))->addClass('col-md-1'), 'date');
        $form->addFieldToGroup((new datePickerField('from'))->addClass('col-md-3'), 'date');
        $form->addFieldToGroup((new markupField('to_label', 'To:'))->addClass('col-md-1'), 'date');
        $form->addFieldToGroup((new datePickerField('to'))->addClass('col-md-3'), 'date');
        if($currentUser->isAllowed('ViewTeamReports') || $currentUser->isAllowed('ViewCompanyReports')) {
            $form->addFieldToGroup((new checkboxField('new_starter'))->setLabel('New starter')->addClass('col-md-3'), 'date');
        }
        return System::asJson($response, $form->getBuiltFormArray());
    }


}