<?php

namespace apexl\Io\modules\coachingFormsDisplay\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\coachingForms\entities\coachingAnswersEntity;
use apexl\Io\modules\coachingForms\entities\packagesEntity;
use apexl\Io\modules\coachingForms\entities\questionsEntity;
use apexl\Io\modules\formbuilder\includes\markupField;
use apexl\Io\modules\formbuilder\includes\radioGroupField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class callbackController extends coachingDisplayFormsController {

    /**
     * Callback to add selected package fields to forms
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     */
    public function getPackageFields(Request $request, Response $response, $args){
        $package = new packagesEntity();
        $package->load($args['id']);

        $completedForm = NULL;
        if($formId = $args['formId'] ?? FALSE){
            $completedForm = new coachingAnswersEntity();
            $completedForm->load($args['formId']);
        }
        //This is a callback so we can't return the full form. Instead we need to build the group object
        $packageGroup = (object)[];

        if($package->id ?? FALSE){
            $packageGroup->fieldset = (object)[];
            $packageGroup->fieldset->fieldset_settings = (object)['fieldset_legend' => $package->name, 'fieldset_classes' => "row fieldset-package-".$package->id, 'overview' => true, 'is_collapsable' => false];

            $headerFields = $this->categoryHeaderFields($package->id);
            $group = [];
            foreach($headerFields as $key => $headerField) {
                $group[$headerField->field->name] = $headerField->field;
            }

            $packageGroup->fieldset->{'fieldGroup_categoryheadergroup'.$package->id} = (object)$group;

            $packageQuestions = $package->getQuestions();
            foreach($packageQuestions as $question){
                $questionGroup = [];
                $questionRow = $this->questionRowFields($question, $completedForm);
                foreach($questionRow as $questionField) {
                    $questionGroup[$questionField->field->name] = $questionField->field;
                }

                $packageGroup->fieldset->{'fieldGroup_questiongroup'.$question->id} = (object)$questionGroup;
            }

            return System::asJson($response, $packageGroup);
        } else {
            return System::asJson($response, ['messages' => [
                [
                    'type' => 'failed',
                    'content' => 'Cannot find the selected package',
                ]
            ]], 404);
        }
    }

    public function questionInfo(Request $request, Response $response, $args){
        //callback is to grab the question's score.
        if($id = $args['id'] ?? FALSE){
            $question = new questionsEntity();
            $question->load($id);
            return System::asJson($response, $question->getData());
        }
        return System::asJson($response, '', 404);
    }
}