<?php

namespace apexl\Io\modules\coachingFormsDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\modules\coachingForms\entities\questionsEntity;
use apexl\Io\modules\display\pages\genericPage;
use apexl\Io\modules\formbuilder\includes\markupField;
use apexl\Io\modules\formbuilder\includes\radioGroupField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\services\currentUser;

class coachingDisplayFormsController extends Controller{
    protected $page;
    protected $menu;
    protected $currentUser;
    protected $genericPage;

    public function __construct(Page $page, Menu $menu, currentUser $currentUser)
    {
        parent::__construct();
        $this->page = $page;
        $this->menu = $menu;
        $this->currentUser = $currentUser::getCurrentUser();
        $this->genericPage = new genericPage($this->menu, $this->currentUser);
    }

    /**
     * Function to build question group form objects. In base controller to be inheritable by chile classes
     * @param $questionGroups
     * @param string $type
     * @param bool $isEdit
     * @return array
     */
    protected function buildQuestionSet($questionGroups, $type = 'category', $isEdit = FALSE): array
    {
        $repeatingValue = [];
        $i = 0; //JS will convert a PHP array to an object for non sequential keys, so we need to store category ID another way
        foreach($questionGroups as $questionGroup) {
            //grab category questions, and build the form row.
            $repeatingValue[$i] = (object)['name' => $questionGroup->name, 'category_id' => $questionGroup->id];
            $questionsEntity = new questionsEntity();
            if($type == 'category') {
                $questions = $questionsEntity->getCategoryQuestions($questionGroup->id);
            } else {
                $questions = $questionsEntity->getPackageQuestions($questionGroup->id);
            }
            foreach($questions as $question){
                if(!isset($repeatingValue[$i]->questions)){
                    $repeatingValue[$i]->questions = [];
                    $repeatingValue[$i]->scores = [];
                    $repeatingValue[$i]->isEdit = [];
                }
                $repeatingValue[$i]->questions[$question->id] = $question->name;
                $repeatingValue[$i]->scores[$question->id] = $question->score;
                if($isEdit){
                    $repeatingValue[$i]->isEdit[$question->id] = true;
                }
            }
            $i++;
        }
        return $repeatingValue;
    }

    /**
     * @param $id
     * @return array
     */
    protected function categoryHeaderFields($id): array
    {
        $headerFields = [];
        $headerFields[] = (new markupField('category_header_1_'.$id, ''))->addClass('col-md-6 category-header');
        $headerFields[] = (new markupField('category_header_2_'.$id, 'Demonstrated?'))->addClass('col-md-3 category-header');
        $headerFields[] = (new markupField('category_header_3_'.$id, 'Comments'))->addClass('col-md-3 category-header');
        return $headerFields;
    }

    protected function questionRowFields($question, $answers = NULL){
        $questionText = (new markupField('question_'.$question->id, $question->name))->addClass('col-md-6 question-cell');
        $demonstrated = (new radioGroupField('question_radios_'.$question->id, [1 => 'Yes', 2 => 'No', 3 => 'N/A']))->addClass('col-md-3 question-cell')->isRequired()->setCallback('/api/display/callbacks/question/'.$question->id);
        $comments = (new textareaField('question_comments_'.$question->id))->addClass('col-md-3 question-cell')->isRequired()->setRows(2);

        if($answers){
            if(
                isset($answers->categories[$question->parentId])
                && isset($answers->categories[$question->parentId]->questions)
                && isset($answers->categories[$question->parentId]->questions[$question->id])
            ){
                $demonstrated->setValue($answers->categories[$question->parentId]->questions[$question->id]->demonstrated_raw);
                $comments->setValue($answers->categories[$question->parentId]->questions[$question->id]->comment);
            }
        }

        return [$questionText, $demonstrated, $comments];
    }
}